#ifndef _H_GPS_H
#define _H_GPS_H

#include "mbed.h"

/// Manages the nano hornet GPS add-on chip.
class GPS
{
public:
    /// Constructor
    /// @param pc The serial (UART) port used to communicate with the GPS. Data is only received, nothing is sent to this port.
    GPS(Serial const &pc);

    class Delegate
    {
        virtual void gpsSync() = 0;
    };

    void powerOn();
    void powerOff();

private:
    Serial* uart;

};

#endif//_H_GPS_H