#ifndef _H_CHERRYCAM_H
#define _H_CHERRYCAM_H

#include "mbed.h"

/// Manages the camera used on the CarbonFlyer
class CherryCam
{
public:
    CherryCam();            ///< Constructor

    void powerOn();         ///< Turn the camera power on. Takes 10-12 sec to boot up.
    void powerOff();        ///< Turn the camera power off.
    void start();           ///< Start video recording. Camera power must be on.
    void stop();            ///< Stop the video recording.

private:
    void generateFallingEdge();
    void pulldownShutterPin();
    DigitalOut powerPin;
    DigitalOut shutterPin;
    Timeout pulldownTimer;
    bool recording;
};

#endif//_H_CHERRYCAM_H