#include "CherryCam.h"

CherryCam::CherryCam() : powerPin(p26), shutterPin(p30), recording(false)
{
    powerPin = 0; // keep off initially
}

void CherryCam::powerOn()
{
    powerPin = 1;
}

void CherryCam::powerOff()
{
    powerPin = 0;
}

void CherryCam::start()
{
    if (recording)
        return;

    generateFallingEdge();
}

void CherryCam::stop()
{
    if (!recording)
        return;

    generateFallingEdge();
}

void CherryCam::generateFallingEdge()
{
    shutterPin = 1;
    pulldownTimer.attach(this, &CherryCam::pulldownShutterPin, 0.5); // pull down after 1 sec
}

void CherryCam::pulldownShutterPin()
{
    shutterPin = 0;
    recording = !recording;
}