#ifndef _H_MAGNETOMETER_H
#define _H_MAGNETOMETER_H

#include "I2CPeripheral.h"
#include "Sensor.h"
#include "CalibrateMagneto.h"

class Magnetometer : public I2CPeripheral, public Sensor
{
public:
    Magnetometer(I2C &i2c);

    virtual bool powerOn();
    virtual void powerOff();
    virtual void start();
    virtual void stop();

    virtual Vector3 read();

    bool performSelfTest();

    void getCalibration(Vector3 &mins, Vector3 &maxs);

private:
    // Calibration data
    int8_t   dig_x1;
    int8_t   dig_y1;
    int8_t   dig_x2;
    int8_t   dig_y2;
    uint16_t dig_z1;
    int16_t  dig_z2;
    int16_t  dig_z3;
    int16_t  dig_z4;
    uint8_t  dig_xy1;
    int8_t   dig_xy2;
    uint16_t dig_xyz1;

    // Hard iron cancellation data
    CalibrateMagneto calibrator;

    void readCalibrationData();

    InterruptIn int1;
    InterruptIn int2;
};

#endif//_H_MAGNETOMETER_H