#ifndef _H_GYROSCOPE_H
#define _H_GYROSCOPE_H

#include "I2CPeripheral.h"
#include "Sensor.h"

class Gyroscope : public I2CPeripheral, public Sensor
{
public:
    Gyroscope(I2C &i2c);

    void handleInterrupt(void);

    virtual void powerOff();
    virtual bool powerOn();
    virtual void start();
    virtual void stop();
    virtual Vector3 read();

    volatile bool interruptSet;

protected:
    InterruptIn int1;
    InterruptIn int2;
    size_t      tick;
};

#endif//_H_GYROSCOPE_H