#ifndef _H_BAROMETER_H
#define _H_BAROMETER_H

#include "I2CPeripheral.h"
#include "Sensor.h"

class Barometer : public I2CPeripheral, public Sensor
{
private:
    // These typedefs are for Bosch's conversion algorithms below
    typedef uint32_t BMP280_U32_t;
    typedef int32_t  BMP280_S32_t;
    typedef int64_t  BMP280_S64_t;

    void  bmp280_read_calibration();
    float bmp280_val_to_temp(BMP280_S32_t adc_T);
    float bmp280_val_to_pa(BMP280_S32_t adc_P);
    float pressureToAltitude(const float pa) const;
    float sum;
    float avg;
    int nsamples;

    // Calibration parameters stored on chip
    // XXX: DO NOT modify the order, values are read into this section of the memory sequentially!
    uint16_t dig_T1;
    int16_t  dig_T2;
    int16_t  dig_T3;
    uint16_t dig_P1;
    int16_t  dig_P2;
    int16_t  dig_P3;
    int16_t  dig_P4;
    int16_t  dig_P5;
    int16_t  dig_P6;
    int16_t  dig_P7;
    int16_t  dig_P8;
    int16_t  dig_P9;
    BMP280_S32_t t_fine; // t_fine carries fine temperature as global value

public:
    Barometer(I2C &i2c);

    virtual bool powerOn();
    virtual void powerOff();
    virtual void start();
    virtual void stop();

    virtual Vector3 read();
};

#endif