//Tested: NUCLEO-F401RE
#include "mbed.h"

/****************** START BLE Declaration ****************/
#include "ble/BLE.h"
#include "LEDService.h"

DigitalOut Led1(LED1);
DigitalOut myLED(PB_2);
DigitalOut myRelay(PA_15);
DigitalIn myButton(USER_BUTTON);
Serial pc(USBTX, USBRX); 

DigitalOut OutRed(PA_4);
DigitalOut OutBlue(PA_1);
DigitalOut OutGreen(PB_0);


const static char     DEVICE_NAME[] = "UART";
static const uint16_t uuid16_list[] = {LEDService::LED_SERVICE_UUID};

LEDService *ledServicePtr;
/***************** END BLE Declaration ********************/

/**************** START BLE Functions **********************/

//****************************************************************
//* Disconnection Callback
//****************************************************************
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void)params;
    BLE::Instance().gap().startAdvertising(); // restart advertising
    
     pc.printf("------ Sono qui 3 disconnetrionCallBack \r\n", error);
}

//****************************************************************************************
//* This callback allows the LEDService to receive updates to the ledState Characteristic.
//*
//* @param[in] params
//*     Information about the characterisitc being updated.
//****************************************************************************************
void onDataWrittenCallback(const GattWriteCallbackParams *params) 
{
    if ((params->handle == ledServicePtr->getValueHandle()) && (params->len == 1)) 
    {
        switch(*(params->data))
        {
            case 0:
            {
                Led1 = 0x00; // spegni LED su scheda 
                //++++++++++++++ INIZIO pilota accensione delle strip LED +++++++++++++++++++++++++
                OutRed = 0;
                OutGreen = 0;
                OutBlue = 0;
                //++++++++++++++ FINE pilota accensione delle strip LED +++++++++++++++++++++++++

            } break;
            case 1:
            {
                Led1 = 0x01; // accendi LED su scheda
                //++++++++++++++ INIZIO pilota accensione delle strip LED +++++++++++++++++++++++++
                OutRed = 1;
                OutGreen = 0;
                OutBlue = 0;
                //++++++++++++++ FINE pilota accensione delle strip LED +++++++++++++++++++++++++
            } break;
            case 2:
            {
                Led1 = 0x00; // spegni LED su scheda 
                //++++++++++++++ INIZIO pilota accensione delle strip LED +++++++++++++++++++++++++
                OutRed = 0;
                OutGreen = 1;
                OutBlue = 0;
                //++++++++++++++ FINE pilota accensione delle strip LED +++++++++++++++++++++++++

            } break;
            case 3:
            {
                Led1 = 0x01; // accendi LED su scheda 
                //++++++++++++++ INIZIO pilota accensione delle strip LED +++++++++++++++++++++++++
                OutRed = 0;
                OutGreen = 0;
                OutBlue = 1;
                //++++++++++++++ FINE pilota accensione delle strip LED +++++++++++++++++++++++++

            } break;
            case 4:
            {
                Led1 = 0x01; // accendi LED su scheda 
                //++++++++++++++ INIZIO pilota accensione delle strip LED +++++++++++++++++++++++++
                OutRed = 1;
                OutGreen = 1;
                OutBlue = 1;
                //++++++++++++++ FINE pilota accensione delle strip LED +++++++++++++++++++++++++

            } break;
            case 5:
            {
                Led1 = 0x00; // spegni LED su scheda 
                myRelay = 0x00; // spegni Relay
            } break;
            
            default: break;
        }
        pc.printf("\n\r---- Ricevuto: %d \n\r",*(params->data));
        
        //Led1 = *(params->data); // in params->data riceve il byte inviato dal cellulare
    }
}

//************************************************************************** 
//* This function is called when the ble initialization process has failled 
//************************************************************************** 
void onBleInitError(BLE &ble, ble_error_t error) 
{ 
    /* Initialization error handling should go here */ 
} 

//************************************************************************** 
//* Callback triggered when the ble initialization process has finished 
//************************************************************************** 
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params) 
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) 
    {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) 
    {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);

    bool initialValueForLEDCharacteristic = true;
    ledServicePtr = new LEDService(ble, initialValueForLEDCharacteristic);

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); // 1000ms.
    ble.gap().startAdvertising();

    while (true) 
    {
        ble.waitForEvent();
        //pc.printf("-------- Sono qui 1 WaitForEvent() \n\r");
    }
}
/******************* END BLE Functions *************************/


/********/
/* MAIN */
/********/
int main(void)
{
    // configura velocità della comunicazione seriale su USB-VirtualCom e invia messaggio di benvenuto
    pc.baud(9600); //921600 bps
    // messaggio di benvenuto
    pc.printf("\r\n*************** Hallo *********************\r\n");
    pc.printf("\r\n*** Bluetooth Driving for LED and Relay ***\r\n");
    
    //imposta il funzionamento del pulsante come "PullDown": Aperto = '0'. L'altra modalità di funzinamento è PullUp
    myButton.mode(PullDown);
    
    // inizializza variabili
    OutRed=0;
    OutBlue=0;
    OutGreen=0;
    
    //+++++++++++++ INIZIO ciclo di prova  ++++++ 
    /*
    while(true)
    {
        if(myButton==0x01)
        {
            myLED=0x01;
            //while(myButton !=0x00);
            Led1=0x01;
            myRelay=0x01; // accendi relay
            OutRed = 1;
            OutGreen = 1;
            OutBlue = 1;
                
        }
        else
        {
            myLED=0x00;
            Led1=0x00;
            myRelay=0x00; // spegni relay
            OutRed = 0;
            OutGreen = 0;
            OutBlue = 0;
        }
    }
    */
    //++++++ FINE Ciclo di Prove
    /*************** START BLE Main ************/
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    /*************** END BLE Main ***********/
    
    
    
}

