//Digipot code with 2nd CAN Transceiver for testing

#include "mbed.h"

static int id = 0x02;       //Module CAN ID, to be assigned by keypad team.
static double input_amp = 3.3; //input analog signal is 3.3V

static double R1 = 9.80;    //Opamp resistor between inverting-input and ground
static double R2 = 5.49;    //Opamp resistor between output and inverting-input
static double gain = 1 + R2/R1; //Non-inverting opamp gain

//Debugging Variables
DigitalOut led1(LED1);  //debugging LED1
Ticker ticker;  //triggers debugging send
char counter = 0;   //Output amplitude
CAN can2(p30, p29);                 //2nd debugging send transceiver

//Values to be used in final implementation
DigitalOut led2(LED2);  //debugging LED2
DigitalOut CS(p8);                 // inverted chip select
SPI spi(p5, p6, p7);               // mosi, miso, sclk
CAN can1(p9, p10);                  //reading transceiver


void digipot (int OutputAmp)
{
    CS=0;                       // Deselects the digipot
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(1000000);

    uint8_t wiper = uint8_t(OutputAmp*(255/(input_amp * gain)));    //Generates appropriate Wiper position
    
    spi.write(0x11);      // Write data command, potentiometer zero
    spi.write(wiper);           // Writes wiper value
    
    printf("Wiper Value = %d \n",wiper);
    
    CS=1;                       // Selects the digipot, and executes command
}

void send() //For debugging
{
    if(can2.write(CANMessage(id, &counter, 1))) {
        counter++;
        if(counter ==6)
        {
            counter = 0;    //reset counter
        }
    } 
    led1 = !led1;
}

int main()
{
        ticker.attach(&send,5);    //Debugging: Changes output amplitude every 3 seconds
        
        int OutputAmp = 0;  //Default output amplitude value
        digipot(OutputAmp);
        
        CANMessage msg;
                
        while(1)
        {
            if(can1.read(msg) && msg.id == id)
            {
                OutputAmp = msg.data[0];    //Input is an int 0,1,2,3,4,5
                digipot(OutputAmp);     //set digipot value
                led2 = !led2;
            }
        }
}