#include "mbed.h"
#include "rtos.h"
#include "math.h"
#define REG_CTRL_REG_1    0x2A
#define MMA8452Q_ADDRESS 0x3A
#define MMA8452_ACTIVE_MASK 0x01
#define MMA8452_ACTIVE_MASK2 0x16

Serial pc(USBTX, USBRX); // tx, rx
I2C i2c(p9, p10);
Serial uart(p13, p14);

DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

DigitalOut myled4(LED4);
DigitalOut sw1(p8);


DigitalOut cs(p8);
DigitalIn baide(p15);
DigitalIn bannule(p16);

void thread_tombe();
void thread_boutton();
Thread thtombe(thread_tombe);
void sendSignal_tombe();
Thread thboutton(thread_boutton);
void sendSignal_boutton();

bool etat = false;

void envoie()
{
    char frame[24];

    char frameType = 0x10;
    frame[0]= 0x7E;
    frame[1]= 0x00;
    frame[2]= 0x12;
    frame[3]= 0x10;
    frame[4]= 0x01;
    frame[5]= 0x00;
    frame[6]= 0x00;
    frame[7]= 0x00;
    frame[8]= 0x00;
    frame[9]= 0x00;
    frame[10]= 0x00;
    frame[11]= 0x00;
    frame[12]= 0x00;
    frame[13]= 0xFF;
    frame[14]= 0xFE;
    frame[15]= 0x00;
    frame[16]= 0x00;
    if(etat) {
        frame[17]= 0x01;
    } else {
        frame[17]= 0x00;
    }

    frame[18]= 0x12;
    frame[19]= 0x63;
    frame[20]= 0x92;

    char checksum =0;
    for(int i =3; i < 22; i++) {
        checksum += frame[i];
    }
    checksum =checksum&0xff;
    checksum= 0xff-checksum;
    frame[21]= checksum;
    int success = 1;
    myled4 =1;
    while(success != 0x00) {
        for(int i=0; i<22; i++) {
            uart.putc(frame[i]);
        }
        while(!uart.readable()) { }
        char frame_received[11];
        char first = uart.getc();
        while(first != 0x7E) {
            first = uart.getc();
            if(first == 0x7E) {
                frame_received[0] = first;
                frame_received[1] = uart.getc();
                frame_received[2] = uart.getc();
                frame_received[3] = uart.getc();
                if(frame_received[3] != 0x8B)
                    first =0x00;
            }
        }
        for(int i=4; i<11; i++) {
            frame_received[i] = uart.getc();
        }
        success = (int)frame_received[8];
    }

}

void thread_boutton()
{
    while(true) {
        Thread::signal_wait(0x1);
        if( bannule) {
            myled2 =0;
            etat = false;
            envoie();
            wait(1);
            myled4 =0;
        }
        if( baide) {
            etat=true;
            envoie();
            etat = false;
            wait(1);
            myled2 =1;
            myled4 =0;
        }

    }

}
void thread_tombe()
{
    char buf[2] = {0,0};
    buf[0] = REG_CTRL_REG_1;
    buf[1] = MMA8452_ACTIVE_MASK;
    i2c.write(MMA8452Q_ADDRESS, buf,2);

    int counter = 0;
    int last[200];
    bool ready =false;
    bool down =false;
    int countup = 0;
    wait(1);
    while(1) {
        Thread::signal_wait(0x1);

        double x, y, z;
        char data[6];
        char add;

        add=MMA8452_ACTIVE_MASK;

        i2c.write(MMA8452Q_ADDRESS,&add,1,true);
        i2c.read(MMA8452Q_ADDRESS,(char*)data,6);


        //Reading each force from the array
        int16_t dataValue = 0;
        ((char*)&dataValue)[1] = data[0];
        ((char*)&dataValue)[0] = data[1];
        x= (dataValue>>4);
        ((char*)&dataValue)[1] = data[2];
        ((char*)&dataValue)[0] = data[3];
        y= (dataValue>>4);
        ((char*)&dataValue)[1] = data[4];
        ((char*)&dataValue)[0] = data[5];
        z= (dataValue>>4);

        z = std::abs(z);
        y = std::abs(y);
        x = std::abs(x);
        double g = sqrt(z*z+x*x+y*y);

        last[counter]= (int)g;
        if(counter == 20) {
            counter = 0;
            ready = true;
        } else counter++;

        if(ready) {

            if(g<600) { //chute
                down =true;
                countup=0;
            } else if(countup>=20) { //analyse des valeur
                down = false;
                int moy=0;
                int i;

                for(i = 0; i<21; i++) {
                    moy= moy+last[i];
                }
                if((moy/i)>1600) {
                    myled=1;
                    etat= true;
                    envoie();
                    wait(1);
                    etat= false;
                }
                countup=0;
            } else if(down) { //attente d'avoir assez de valeur
                countup++;
            }
        }
    }
}

int main()
{
    sw1 =0;
    wait(0.4);
    sw1 =1;
    wait(5);
    Ticker tic_tombe;
    tic_tombe.attach(&sendSignal_tombe, 0.01);  //tick a chaque 250ms pour la thread analogue

    Ticker tic_boutton;
    tic_boutton.attach(&sendSignal_boutton, 0.05);  //tick a chaque 250ms pour la thread analogue
    while(true) {
        if(uart.readable()) {
            // pc.putc(uart.getc());
        }
        if(pc.readable()) {
            //uart.putc(pc.getc());
        }
    }
}
void sendSignal_tombe()
{
    thtombe.signal_set(0x1);
}
void sendSignal_boutton()
{
    thboutton.signal_set(0x1);
}