#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "ID12RFID.h"
#include "XBeeLib.h"
#include "DigiLoggerMbedSerial.h"

using namespace XBeeLib;
//static const char* mbedIp       = "192.168.1.2";
//static const char* mbedMask     = "255.255.255.0";
//static const char* mbedGateway  = "192.168.1.1";
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
//static char* WEBSOCKET_URL= "ws://braceletus.herokuapp.com:8080/"; // Adresse Serveur M-A
//static char* WEBSOCKET_URL = "ws://24.203.139.78:8080/"; // Adresse Serveur M-A
static char* WEBSOCKET_URL = "ws://192.168.0.20:3000/"; // Adresse Serveur M-A
DigitalOut sw(p20);
void keep_alive();
Thread thread_alive(keep_alive);


ID12RFID rfid(p10); // uart rx
//EthernetInterface eth;
Websocket ws(WEBSOCKET_URL);

static void receive_cb(const RemoteXBeeZB& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{
    const uint64_t remote_addr64 = remote.get_addr64();

    for (int i = 0; i < len; i++)
        pc.printf("%02x ", data[i]);
    sw = (bool)data[0];
    uint32_t x ;                //Construire le ID avec les 3 char recu
    x = data[1];
    x= (x<<8)|data[2];
    x= (x<<8)|data[3];

    pc.printf("%d %02x %02x %02x", x, data[1], data[2], data[3]);

    char message[64];
    sprintf(message,"1,%d,%d",x,data[0]) ;

    if(ws.send(message)==-1) {
        ws.close();
        ws.connect();
        ws.send(message);
    } //envoie de message de chute


    pc.printf("\r\n");
}


void keep_alive()
{
    Thread::signal_wait(0x1);       //signal keep alive pouvant être utilisé plus tard pour vérifier que les poste fixe sont fonctionnel
    ws.send("2");
}
void sendSignal()
{
    thread_alive.signal_set(0x1);
}

int main()
{
    
    // Setup du port ethernet
    EthernetInterface eth;
    eth.init(); //Use DHCP
    //eth.init(mbedIp, mbedMask, mbedGateway); //Use config
    eth.connect();
    //printf("IP Address is %s\n\r", eth.getIPAddress());

    XBeeZB xbee = XBeeZB(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);

    /* Register callbacks */
    xbee.register_receive_cb(&receive_cb);
    Ticker ticker_num;
    RadioStatus const radioStatus = xbee.init();
    
    if(ws.connect()) {
        pc.printf("ok");
    } else {
        pc.printf("bad");
    }
    ticker_num.attach(&sendSignal, 15);  //tick a chaque 50ms pour la thread numerique
    myled = false;

    while (1) {
        xbee.process_rx_frames();

        if(rfid.readable()) {
            int i = rfid.read();
            printf("RFID Tag number : %d\n", i);
            char message[64];
            sprintf(message,"0,%d,1",i) ;
            
            if(ws.send(message)==-1) {
                ws.close();
                ws.connect();
                ws.send(message);
            } //envoie de commande rfid


        }
        wait_ms(100);       
    }
}
