#include "mbed.h"

#include "X_NUCLEO_NFC01A1.h"
#include "NDefLib/NDefNfcTag.h"
#include "NDefLib/RecordType/RecordURI.h"
#include "NDefLib/RecordType/RecordText.h" 


int updateM24SR(X_NUCLEO_NFC01A1* nfcNucleo, char* data){
    
    //retrieve the NdefLib interface
    NDefLib::NDefNfcTag& tag =nfcNucleo->getM24SR().getNDefTag();
    printf("System Init done: !\n\r");
    /*SESSION 1*/
    //open the i2c session with the nfc chip
    if(tag.openSession()){
        printf("Session opened\n\r");
        nfcNucleo->getLed1()=1;
        
        //create the NDef message and record
        NDefLib::Message msg;
        NDefLib::RecordText rText(data);
        msg.addRecord(&rText);
        
        //write the tag
        if(tag.write(msg)){
            printf("Tag written\n\r");
            nfcNucleo->getLed2()=1;
           
        }else{
            printf("Error writing \n\r");
        }//if-else

        //close the i2c session
        if(tag.closeSession()){
           printf("Session closed\n\r");
           nfcNucleo->getLed3()=1;
        }else{
           printf("Error closing the session\n\r");
        }//if-else
        
    }else
        printf("Error opening the session\n\r");
    }

int main(void){
    
    //use default board pinout
    I2C i2cChannel(X_NUCLEO_NFC01A1::DEFAULT_SDA_PIN,X_NUCLEO_NFC01A1::DEFAULT_SDL_PIN);
    X_NUCLEO_NFC01A1 *nfcNucleo = X_NUCLEO_NFC01A1::Instance(i2cChannel,NULL,
            X_NUCLEO_NFC01A1::DEFAULT_GPO_PIN,X_NUCLEO_NFC01A1::DEFAULT_RF_DISABLE_PIN,
            X_NUCLEO_NFC01A1::DEFAULT_LED1_PIN,X_NUCLEO_NFC01A1::DEFAULT_LED2_PIN,
            X_NUCLEO_NFC01A1::DEFAULT_LED3_PIN);
    
    //retrieve the NdefLib interface
    NDefLib::NDefNfcTag& tag =nfcNucleo->getM24SR().getNDefTag();
    printf("System Init done: !\n\r");
    
    updateM24SR(nfcNucleo,"CIAO ANITA");
    
}