/*
 * LedCtrl.cpp
 *
 *  Created on: 26 mars 2018
 *      Author: hd01073
 */


#include <stdio.h>
#include "mbed.h"
#include "mbed_events.h"

#include "BNP_Ctrl.h"
#include "LedCtrl.h"
#include "APA102.h"

#define REFRESH_DELAY_MS 50 			// work around hardware issue

#define CATERPILLAR_STR1_LEN 3
#define CATERPILLAR_STR1_OFFSET 1
#define CATERPILLAR_STR2_LEN 5
#define CATERPILLAR_STR2_OFFSET 2

// keep care BGR not RGB !!!
#define BLUE	((unsigned int)0x00FF0000)
#define GREEN 	((unsigned int)0x0000FF00)
#define RED		((unsigned int)0x000000FF)
#define ORANGE 	((unsigned int)0x0000A5FF)
#define CYAN 	((unsigned int)0x00FEFE00)


#define COLOR_TO_IRGB(intensity, color) 	\
	(((unsigned int)0xE0000000) 			|	\
	 ((unsigned int)intensity << 24)		|	\
	 color)

#define MAX_LIGHT_INTENSITY 	30
#define MEDIUM_LIGHT_INTENSITY	12

APA102 *ledString1P = 0 ;
APA102 *ledString2P = 0 ;

unsigned int frameB1[NB_LED_STR1] ;
unsigned int frameB2[NB_LED_STR2] ;


LedCtrl *LedCtrl::singleInstP = 0 ;
LedCtrl::Activity LedCtrl::currentActivity = LedCtrl::noActivity ;
LedCtrl::Activity LedCtrl::requiredActivity = LedCtrl::noActivity ;

DigitalOut pb15(PB_15) ;
DigitalOut pc2(PC_2) ;
DigitalOut pb10(PB_10) ;
 
LedCtrl::LedCtrl(void):
	delayRequestId(0),
	currentActivityCtxtP(0),
	noActivityCtxt(*this),
	signalingTermIdleCtxt(*this),
	signalingTermSelectedCtxt(*this),
	signalingPlugSelectedCtxt(*this),
	signalingChargingCtxt(*this),
	signalingChargeSuspendedCtxt(*this)
{
	//frameB1 = new unsigned int[NB_LED_STR1] ; // does not work !!! Mapping issue ? replaced by static alloc
	//frameB2 = new unsigned int[NB_LED_STR2] ;
	if (!ledString1P) ledString1P = new APA102 (PB_5, PA_6, PB_3,   850000) ;
	if (!ledString2P) ledString2P = new APA102 (PB_15, PC_2, PB_10, 850000) ;

	ctxtAP[noActivity] = &noActivityCtxt ;
	ctxtAP[signalingTermIdle] = &signalingTermIdleCtxt ;
	ctxtAP[signalingTermSelected] = &signalingTermSelectedCtxt ;
	ctxtAP[signalingPlugSelected] = &signalingPlugSelectedCtxt ;
	ctxtAP[signalingCharging] = &signalingChargingCtxt ;
	ctxtAP[signalingChargeSuspended] = &signalingChargeSuspendedCtxt ;
}

LedCtrl::~LedCtrl(void)
{
}


void LedCtrl::signalEvent(Evt evt)
{
	mainQueueP->call(instanceFeedFsm, evt) ;
}

void LedCtrl::expirationDelayHdlr(void)
{
	LedCtrl &ledCtrl = *singleInstP ;
	if (ledCtrl.currentActivityCtxtP) {
		ledCtrl.currentActivityCtxtP->keepAlive() ;
	}
}

void LedCtrl::refreshDelayHdlr(void)
{
	LedCtrl &ledCtrl = *singleInstP ;
	if (ledCtrl.currentActivityCtxtP->nbRefresh <= 0) {
		ledCtrl.currentActivityCtxtP->keepAlive() ;
	} else {
		ledString1P->Repaint() ;
		ledString2P->Repaint() ;
		ledCtrl.currentActivityCtxtP->nbRefresh-- ;
		mainQueueP->call_in(REFRESH_DELAY_MS, refreshDelayHdlr) ;
	}
}

void LedCtrl::init(void)
{
	ledString1P->SetBuffer(frameB1, 1, NB_LED_STR1, 1, 1, false, false) ;
	ledString2P->SetBuffer(frameB2, 1, NB_LED_STR2, 1, 1, false, false) ;

}

void LedCtrl::feedFsm(LedCtrl::Evt evt)
{
	(void)evt ; 				// only one event declared presently - don't care
	printf ("\r\nLedCtrl: new evt") ;
	if (delayRequestId) {
		mainQueueP->cancel(delayRequestId);
		delayRequestId = 0 ;
	}
	currentActivity = requiredActivity ;
	currentActivityCtxtP = ctxtAP[currentActivity] ;
	currentActivityCtxtP->start() ;

}


LedCtrl::NoActivityCtxt::NoActivityCtxt(LedCtrl &_ledCtrl) :
		ActivityCtxt(ledCtrl)
{
}

void LedCtrl::NoActivityCtxt::start(void)
{
	printf ("\r\nLedCtrl::NoActivityCtxt::start") ;
	lightIntensity = 0 ;
	unsigned int irgbCode = COLOR_TO_IRGB(lightIntensity, GREEN) ;
	for (int i = 0 ; i < NB_LED_STR1 ; ++i) frameB1[i] = irgbCode ;
	for (int i = 0 ; i < NB_LED_STR2 ; ++i) frameB2[i] = irgbCode ;
	ledString1P->Repaint() ;
	ledString2P->Repaint() ;
}

void LedCtrl::NoActivityCtxt::keepAlive(void)
{
}

///////////////////////

LedCtrl::SignalingTermIdleCtxt::SignalingTermIdleCtxt(LedCtrl &_ledCtrl) :
				ActivityCtxt(ledCtrl)
{
}

void LedCtrl::SignalingTermIdleCtxt::start(void)
{
	printf ("\r\nLedCtrl::SignalingTermIdleCtxt::start") ;
	lightIntensity = 1 ;
	increaseIntensB = false ;
	this->keepAlive() ;
}

void LedCtrl::SignalingTermIdleCtxt::keepAlive(void)
{
	int delayNextRepaint ;
	if (increaseIntensB) {
		if (lightIntensity < MEDIUM_LIGHT_INTENSITY) {
			delayNextRepaint = 200 ;
			lightIntensity++ ;
		} else {
//			printf ("\r\nLedCtrl::SignalingTermIdleCtxt::keepAlive - intens = MEDIUM_LIGHT_INTENSITY" ) ;
			delayNextRepaint = 2000 ;
			increaseIntensB = false ;
		}
	} else {
		if (lightIntensity > 0) {
			delayNextRepaint = 100 ;
			lightIntensity-- ;
		} else {
//			printf ("\r\nLedCtrl::SignalingTermIdleCtxt::keepAlive - intens = 0" ) ;
			delayNextRepaint = 4000 ;
			increaseIntensB = true ;
		}
	}
	unsigned int irgbCode = COLOR_TO_IRGB(lightIntensity, CYAN) ;
	for (int i = 0 ; i < NB_LED_STR1 ; ++i) frameB1[i] = irgbCode ;
	for (int i = 0 ; i < NB_LED_STR2 ; ++i) frameB2[i] = irgbCode ;
	ledString1P->Repaint() ;
	ledString2P->Repaint() ;
	mainQueueP->call_in(delayNextRepaint, expirationDelayHdlr) ;
}


///////////////////////

LedCtrl::SignalingTermSelectedCtxt::SignalingTermSelectedCtxt(LedCtrl &_ledCtrl) :
				ActivityCtxt(ledCtrl)
{
}


void LedCtrl::SignalingTermSelectedCtxt::start(void)
{
	printf("\r\nLedCtrl::SignalingTermSelectedCtxt::start") ;
	lightIntensity = 0 ;
	this->keepAlive() ;
}


void LedCtrl::SignalingTermSelectedCtxt::keepAlive(void)
{
	unsigned int irgbCode  ;
	if (lightIntensity == MAX_LIGHT_INTENSITY) {
		lightIntensity = 0 ;
//		printf("\r\nLedCtrl::SignalingTermSelectedCtxt::keepAlive intensity 0") ;
	} else {
		lightIntensity = MAX_LIGHT_INTENSITY ;
//		printf("\r\nLedCtrl::SignalingTermSelectedCtxt::keepAlive intensity max") ;
	}
	irgbCode = COLOR_TO_IRGB(lightIntensity, CYAN) ;
	for (int i = 0 ; i < NB_LED_STR1 ; ++i) frameB1[i] = irgbCode ;
	for (int i = 0 ; i < NB_LED_STR2 ; ++i) frameB2[i] = irgbCode ;
	ledString1P->Repaint() ;
	ledString2P->Repaint() ;
	nbRefresh = 1000 / REFRESH_DELAY_MS ;
	mainQueueP->call_in(REFRESH_DELAY_MS, refreshDelayHdlr) ;
}



///////////////////////

LedCtrl::SignalingPlugSelectedCtxt::SignalingPlugSelectedCtxt(LedCtrl &_ledCtrl) :
				ActivityCtxt(ledCtrl)
{
}

void LedCtrl::SignalingPlugSelectedCtxt::start(void)
{
	printf("\r\nLedCtrl::SignalingPlugSelectedCtxt::start") ;
	lightIntensity = MAX_LIGHT_INTENSITY ;
	unsigned int irgbCode = COLOR_TO_IRGB(lightIntensity, ORANGE) ;
	for (int i = 0 ; i < NB_LED_STR1 ; ++i) frameB1[i] = irgbCode ;
	for (int i = 0 ; i < NB_LED_STR2 ; ++i) frameB2[i] = irgbCode ;
	ledString1P->Repaint() ;
	ledString2P->Repaint() ;
}

void LedCtrl::SignalingPlugSelectedCtxt::keepAlive(void)
{
}

///////////////////////

LedCtrl::SignalingChargingCtxt::SignalingChargingCtxt(LedCtrl &_ledCtrl) :
				ActivityCtxt(ledCtrl),
				startIdxStr1(0),
				startIdxStr2(0)
{
}

void LedCtrl::SignalingChargingCtxt::start(void)
{
	printf("\r\nLedCtrl::SignalingChargingCtxt::start") ;
	lightIntensity = MAX_LIGHT_INTENSITY ;
	startIdxStr1 = 0 ;
	startIdxStr2 = 0 ;
	this->keepAlive() ;
}

void LedCtrl::SignalingChargingCtxt::keepAlive(void)
{
	unsigned int irgbCodeHigh = COLOR_TO_IRGB(lightIntensity, GREEN) ;
	unsigned int irgbCodeLow = COLOR_TO_IRGB(((unsigned int)0), GREEN) ;
	for (int i = 0 ; i < NB_LED_STR1 ; ++i ) {
		unsigned int irgb ;
		if (i < CATERPILLAR_STR1_LEN) {
			irgb = irgbCodeHigh ;
		} else {
			irgb = irgbCodeLow ;
		}
		frameB1[(i + startIdxStr1) % NB_LED_STR1] = irgb ;
	}
	startIdxStr1 += CATERPILLAR_STR1_OFFSET ;
	for (int i = 0 ; i < NB_LED_STR2 ; ++i ) {
		unsigned int irgb ;
		if (i < CATERPILLAR_STR2_LEN) {
			irgb = irgbCodeHigh ;
		} else {
			irgb = irgbCodeLow ;
		}
		frameB2[(i + startIdxStr1) % NB_LED_STR2] = irgb ;
	}
	startIdxStr2 += CATERPILLAR_STR2_OFFSET ;
	ledString1P->Repaint() ;
	ledString2P->Repaint() ;
	mainQueueP->call_in(400, expirationDelayHdlr) ;
}


///////////////////////

LedCtrl::SignalingChargeSuspendedCtxt::SignalingChargeSuspendedCtxt(LedCtrl &_ledCtrl) :
				ActivityCtxt(ledCtrl)
{
}


void LedCtrl::SignalingChargeSuspendedCtxt::start(void)
{
	printf("\r\nLedCtrl::SignalingChargeSuspendedCtxt::start") ;
	lightIntensity = MAX_LIGHT_INTENSITY;
	unsigned int irgbCode = COLOR_TO_IRGB(lightIntensity, ORANGE) ;
	for (int i = 0 ; i < NB_LED_STR1 ; ++i) frameB1[i] = irgbCode ;
	for (int i = 0 ; i < NB_LED_STR2 ; ++i) frameB2[i] = irgbCode ;
	ledString1P->Repaint() ;
	ledString2P->Repaint() ;
}


void LedCtrl::SignalingChargeSuspendedCtxt::keepAlive(void)
{
}


///////////////////////


