/* 
 * 
 */
#include "mbed.h"
#include "string.h"
#include "mbed_events.h"
#include "ble/BLE.h"
#include "ble/services/UARTService.h"
#if 0
#include "X_NUCLEO_IDB0XA1/x-nucleo-idb0xa1/bluenrg-hci/ble_hci.h"
#endif

#include "BNP_Ctrl.h"
#include "BltLink.h"

#define NEED_CONSOLE_OUTPUT 1

#if NEED_CONSOLE_OUTPUT
#define PRINTF(...) { printf(__VA_ARGS__); }
#else
#define PRINTF(...)
#endif

// static
BltLink *BltLink::singleInstP =  0 ;

const SecurityManager::Passkey_t pinCode = {'6' , '5' , '4' , '3', '2', '1' } ;

void BltLink::connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
	BltLink &bltLink = BltLink::getInst() ;
	bltLink.connectionHandle = params->handle ;
	bltLink.connectedB = true ;
	printf ("Connected!\n\r") ;
}

//static
void BltLink::disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
	BltLink &bltLink = BltLink::getInst() ;
	bltLink.connectedB = false ;
    printf ("Disconnected!\n\r");
    BLE::Instance().startAdvertising();
}


// replace these supplied by mbed.
void UARTService::onDataWritten(const GattWriteCallbackParams *params)
{
	if (params->handle == getTXCharacteristicHandle()) {
		uint16_t bytesRead = params->len;
		PRINTF ("UARTService::received %u bytes\n\r", bytesRead);
		if (bytesRead <= BLE_UART_SERVICE_MAX_DATA_LEN) {
			numBytesReceived   = bytesRead;
			receiveBufferIndex = 0;
			memcpy(receiveBuffer, params->data, numBytesReceived);
			if (!strncmp((char*)receiveBuffer, "$RESERVE", numBytesReceived)) {
				printf("\r\nBltLink : msg RESERVE\n") ;
				BNP_Ctrl::getInst().signalEvent(BNP_Ctrl::oprTerminalReserve) ;
			}
			if (!strncmp((char*)receiveBuffer, "$RELEASED", numBytesReceived)) {
				printf("\r\nBltLink : msg RELEAS\n") ;
				BNP_Ctrl::getInst().signalEvent(BNP_Ctrl::oprTerminalRelease) ;
			}
			if (!strncmp((char*)receiveBuffer, "$PLUG_E", numBytesReceived)) {
				printf("\r\nBltLink : msg PLUG_E\n") ;
				BltLink::getInst().selectedIrisPosition = BNP_Ctrl::irisAtPlugEPosition ;
				BNP_Ctrl::getInst().signalEvent(BNP_Ctrl::oprPlugSelection) ;
			}
			if (!strncmp((char*)receiveBuffer, "$PLUG_C", numBytesReceived)) {
				printf("\r\nBltLink : msg PLUG_C\n") ;
				BltLink::getInst().selectedIrisPosition = BNP_Ctrl::irisAtPlugCPosition ; ;
				BNP_Ctrl::getInst().signalEvent(BNP_Ctrl::oprPlugSelection) ;
			}
			if (!strncmp((char*)receiveBuffer, "$RESUME", numBytesReceived)) {
				printf("\r\nBltLink : msg RESUME\n") ;
				BNP_Ctrl::getInst().signalEvent(BNP_Ctrl::oprResumptionRequest) ;
			}
		}
	}
}


void BltLink::printMacAddress()
{
    /* Print out device MAC address to the console*/
    Gap::AddressType_t addr_type;
    Gap::Address_t address;
    BLE::Instance().gap().getAddress(&addr_type, address);
    printf("DEVICE MAC ADDRESS: ");
    for (int i = 5; i >= 1; i--){
        printf("%02x:", address[i]);
    }
    printf("%02x\r\n", address[0]);
}

#if 0
//static
void BltLink::updateRssi(void)
{
	BltLink &bltLink = getInst() ;
    if (bltLink.connectedB) {
    	*bltLink.led1P = !*bltLink.led1P ;
    	hci_read_rssi(&bltLink.connectionHandle, &bltLink.rssi);
    }
}

#endif
//static
void BltLink::scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context) {
	BLE &ble = BLE::Instance();
    mainQueueP->call(Callback<void()>(&ble, &BLE::processEvents));
}


void BltLink::init(void)
{
    *led1P = 0;

    BLE &ble = BLE::Instance();
    ble.onEventsToProcess(scheduleBleEventsProcessing);
    ble.init();
    for(; !ble.hasInitialized() ; ) ;
    printf ("!!!! ble init done\r\n") ;
    printMacAddress() ;
    ble.gap().onConnection (connectionCallback);
    ble.gap().onDisconnection (disconnectionCallback);

    uartServicePtr = new UARTService(ble) ;
    
     /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME,   //GapAdvertisingData::SHORTENED_LOCAL_NAME, 
                                     (const uint8_t *)"Bk&PlgA", sizeof("Bk&PlgA") - 1);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(1000);   /* in multiples of 0.625ms. */
    ble.gap().startAdvertising();

//    queue.call_every(250, updateRssi);
    printf ("BltLink::init() done\n\r");
}
