/*
 * BNP_Ctrl.h
 *
 *  Created on: 23 mars 2018
 *      Author: hd01073
 */

#ifndef BNP_CTRL_H_
#define BNP_CTRL_H_

#include "mbed.h"
#include "mbed_events.h"

extern EventQueue *mainQueueP ;

class BNP_Ctrl {

public:
	enum Evt {
		irisInitDone,
		irisPositionReached,
		irisPositionTimeOut,
		oprTerminalReserve,
		oprPlugSelection,
		oprTerminalRelease,
		currentDetected,
		currentInterrupted,
		oprResumptionRequest,
		timeoutFired,
		delayExpired
	};

	enum IrisPosition {
		irisNoPostion = -1 ,
		irisAtStopPosition = 0 ,
		irisAtPlugCPosition = 1 ,
		irisAtPlugEPosition = 3 ,
		irisAtShieldPosition = 5 ,
		irisAtCameraPostion = 7 ,
		irisBeyondCamera = 8
	};

	enum AudioTrack {
		noTrack = 0 ,
		trackPlugE = 1 ,
		trackPlugC = 2 ,
		trackResumption = 3
	};

public:
	static BNP_Ctrl *singleInstP ;
	static BNP_Ctrl &getInst(void) {
		if (!singleInstP) {
			singleInstP = new BNP_Ctrl() ;
		}
		return *singleInstP ;
	} ;

	static void deleteInst(void) {
		if (!singleInstP) delete singleInstP ;
	};

	void init(void) ;
	static void signalEvent(Evt evt) ;


private :
	BNP_Ctrl(void) :
		state(noState),
		autoRepeatTimerId(0),
		timeoutId(0),
		delayId(0)
	{
	} ;

	~BNP_Ctrl()
	{
	} ;

	static void instanceFeedFsm(Evt evt)
	{
		singleInstP->feedFsm(evt) ;
	} ;
	static void plugConnectDetect(void) ;
	static void plugDisconnectDetect(void) ;
	static void plugConnectTimeoutHdlr(void) ;
	static void internalDelayExpiredHdlr(void) ;
	void feedFsm(Evt evt) ;

private :
	enum State {
		noState,
		initInProgress,
		idleNoLed,
		idleWithLed,
		terminalSelected,
		plugPresentationInProgress,
		plugPresented,
		waitingPlugConnection,
		chargingInProgress,
		shieldPresentationInProgress,
		chargingSuspended
	};

	State state ;
	int autoRepeatTimerId ;
	int timeoutId ;
	int delayId ;
};



#endif /* BNP_CTRL_H_ */
