/*
 * Audio.h
 *
 *  Created on: 28 mars 2018
 *      Author: hd01073
 */

#ifndef AUDIO_H_
#define AUDIO_H_


#include "mbed.h"
#include "BNP_Ctrl.h"

#define AUDIO_OPT

#ifdef AUDIO_OPT

#define MUTE VOL_0
#define VOL_0 0xFFF0
#define VOL_1 0xFFF1
#define VOL_2 0xFFF2
#define VOL_3 0xFFF3
#define VOL_4 0xFFF4
#define VOL_5 0xFFF5
#define VOL_6 0xFFF6
#define VOL_7 0xFFF7
#define PLAY_PAUSE 0xFFFE
#define STOP 0xFFFF


/**
* soundboard class
* Used to control the WTV020SD board from sparkfun
*/

class soundboard
{
public:
    /** Creates the soundboard class with the specified reset pin, clock pin, data pin and busy pin*/
    soundboard(PinName resetPin, PinName clockPin, PinName dataPin, PinName busyPin);
    
    void startReset(void);
    void startCommand(unsigned int);
 
 private:       
    static void singleInstManageReset(void) ;
    void manageReset(void) ;
    static void singleInstManageCmd(void)  ;
    void manageCmd(void) ;

private:
    DigitalOut _resetPin;
    DigitalOut _clockPin;
    DigitalOut _dataPin;
    DigitalIn _busyPin;   	// TODO : use it as an interrupt with a call back 
    						// function to notify cmd complete. Not wired 
    						// (hardware limitation) presently

private:
	volatile int resetState ;
	volatile int cmdState ;
	unsigned int _cmd ;
	unsigned int _mask ;
	

};


#endif

class Audio {
public:
	static void init(void) ;
	static void startPlay(BNP_Ctrl::AudioTrack track) ;
	
private:
	enum State {
		noState,
		soundResetInProgress,
		sendingVolCmd,
		waitingVolCmdComplete,
		idle,
		sendingPlayCmd,
		waitingPlayCmdComplete
	};

	static State state ;
	static BNP_Ctrl::AudioTrack demandedTrack ;
	
public:
	enum Evt {
		noEvt,
		soundResetComplete,
		soundCmdSent,
		soundNotBusy,
		newJingleRequired
	};

	static void feedFsm(Evt evt) ;
} ;



#endif /* AUDIO_H_ */
