/*
 * MotorCntrl.h
 *
 *  Created on: 26 mars 2018
 *      Author: hd01073
 */

#ifndef MOTORCTRL_H_
#define MOTORCTRL_H_
#include "BNP_Ctrl.h"

class MotorCtrl
{
public:
	static MotorCtrl *singleInstP ;
	static MotorCtrl &getInst(void) {
		if (!singleInstP) singleInstP = new MotorCtrl() ;
				return *singleInstP ;
	};

	static void delInst(void) {
		if (singleInstP) {
			delete singleInstP ;
			singleInstP = 0 ;
		}
	} ;

	enum Evt {
		newPosRequired,
		abortMotionRequired,
		targetPositionReached,
		timeoutEvt
	};

	void init(void) ;
	static void signalEvent(Evt evt) ;

public:
	BNP_Ctrl::IrisPosition targetPosition ;
	BNP_Ctrl::IrisPosition initialPosition ;


private:
	enum State {
		noState,
		initStep1InProgress,
		initStep2InProgress,
		idle,
		motionInProgress
	};
	State state ;
	static int const nbImpulsePerHalfPos = (5024 / 2) ;
	static int itCounterPe1 ;
	static int itCounterPe2 ;
	static int nbImpulseExpected ;
	static bool itCountReachedB ;
	InterruptIn *pe1P ;
	InterruptIn *pe2P ;
	DigitalOut *enableP ;				// PF15
	DigitalOut *forwardClosureP ;		// PE11
	DigitalOut *backwardClosureP ;		// PF14
	int timeoutRequestId ;

private :
	static void timeoutHdlr(void) ;
	static void itHdlrPe1(void) ;
	static void itHdlrPe2(void) ;
	void startMotion(void) ;
	MotorCtrl(void);
	~MotorCtrl(void) ;
	void manageEvtTargetPositionReached(void) ;
	void feedFsm(Evt evt) ;
	static void instanceFeedFsm(Evt evt)
	{
		singleInstP->feedFsm(evt) ;
	} ;
} ;

#endif /* MOTORCTRL_H_ */
