/*
 * MotorCntrl.cpp
 *
 *  Created on: 26 mars 2018
 *      Author: hd01073
 */

#include <stdio.h>
#include "mbed.h"
#include "mbed_events.h"

#include "BNP_Ctrl.h"
#include "MotorCtrl.h"

MotorCtrl *MotorCtrl::singleInstP = 0 ;
int MotorCtrl::itCounterPe1 = 0 ;
int MotorCtrl::itCounterPe2 = 0 ;
int MotorCtrl::nbImpulseExpected = 0 ;
bool MotorCtrl::itCountReachedB = false ;

MotorCtrl::MotorCtrl(void):
	targetPosition (BNP_Ctrl::irisNoPostion),
	initialPosition (BNP_Ctrl::irisNoPostion),
	state(noState),
	pe1P(0),
	pe2P(0),
	enableP(0),
	timeoutRequestId(0)
{
	pe1P = new InterruptIn(PG_0) ;
	forwardClosureP = new DigitalOut(PE_11) ;
	backwardClosureP = new DigitalOut(PF_14) ;
	enableP = new DigitalOut(PF_15) ;

	*forwardClosureP = 0 ;
	*backwardClosureP = 0 ;
	*enableP = 0 ;
}

MotorCtrl::~MotorCtrl(void)
{
	delete pe1P ;
	delete pe2P ;
	delete enableP ;
	delete forwardClosureP ;
	delete backwardClosureP ;
}


void MotorCtrl::signalEvent(Evt evt)
{
	mainQueueP->call(instanceFeedFsm, evt) ;
}

void MotorCtrl::timeoutHdlr(void)
{
	*(singleInstP->forwardClosureP) = 0 ;
	*(singleInstP->backwardClosureP) = 0 ;
	singleInstP->timeoutRequestId = 0 ;
	singleInstP->feedFsm(timeoutEvt) ;
}

void MotorCtrl::itHdlrPe1(void)
{
	itCounterPe1++ ;
	if (itCounterPe1 >= nbImpulseExpected) {
		if (!itCountReachedB) {
			*(singleInstP->forwardClosureP) = 0 ;
			*(singleInstP->backwardClosureP) = 0 ;
			itCountReachedB = true ;
			signalEvent (targetPositionReached) ;
		}
	}
}


void MotorCtrl::itHdlrPe2(void)
{
	itCounterPe2++ ;
	if (itCounterPe2 >= nbImpulseExpected) {
		if (!itCountReachedB) {
			itCountReachedB = true ;
			signalEvent (targetPositionReached) ;
		}
	}
}

void MotorCtrl::startMotion(void)
{
	int nbHalfPosToMove = (int)targetPosition  -(int)initialPosition ;
	itCounterPe1 = 0 ;
	itCounterPe2 = 0 ;
	itCountReachedB = false ;
	if (nbHalfPosToMove > 0) {
		nbImpulseExpected =  nbHalfPosToMove * nbImpulsePerHalfPos ;
		*forwardClosureP = 1 ;
		printf ("\r\nMotorCtrl::startMotion: forward expected %d pulses", nbImpulseExpected) ;
	} else {
		nbImpulseExpected =  nbHalfPosToMove * nbImpulsePerHalfPos * -1 ;
		printf ("\r\nMotorCtrl::startMotion: backward expected %d pulses", nbImpulseExpected) ;
		*backwardClosureP = 1 ;
	}
	timeoutRequestId = mainQueueP->call_in(7000, timeoutHdlr) ;
}

void MotorCtrl::manageEvtTargetPositionReached(void)
{
	if (timeoutRequestId) {
		mainQueueP->cancel(timeoutRequestId);
		timeoutRequestId = 0 ;
	}
	initialPosition = targetPosition ;
}

void MotorCtrl::init(void)
{
	pe1P->rise(itHdlrPe1) ;
	pe1P->enable_irq() ;
	*enableP = 1 ;
	initialPosition = BNP_Ctrl::irisBeyondCamera ; // assume the further position
	targetPosition = BNP_Ctrl::irisAtStopPosition ;
	startMotion();
	state = initStep1InProgress ;
}


void MotorCtrl::feedFsm(Evt evt)
{
	switch (state)
	{
	case initStep1InProgress :
		printf ("\r\nMotorCtrl: state initStep1InProgress") ;
		switch (evt) {
			
		case timeoutEvt :		// in this state timeout is normal
								// since the real initial position is unknown

			*(singleInstP->forwardClosureP) = 0 ;
			*(singleInstP->backwardClosureP) = 0 ;
			printf ("\r\nMotorCtrl: evt target pos assumed to be reached (time-out)") ;
			manageEvtTargetPositionReached() ;
			targetPosition = BNP_Ctrl::irisAtShieldPosition ;
			startMotion();
			state = initStep2InProgress  ;
			break ;

		case targetPositionReached:
			printf ("\r\nMotorCtrl: evt target pos assumed to be reached (time-out)") ;
			manageEvtTargetPositionReached() ;
			targetPosition = BNP_Ctrl::irisAtShieldPosition ;
			startMotion();
			state = initStep2InProgress  ;
			break ;

		default :
			break ;
		}
		break ;

	case initStep2InProgress :
		printf ("\r\nMotorCtrl: state initStep2InProgress") ;
		switch (evt) {
						
		case targetPositionReached:
			printf ("\r\nMotorCtrl: evt target pos reached") ;
			manageEvtTargetPositionReached() ;
			BNP_Ctrl::signalEvent(BNP_Ctrl::irisInitDone) ;
			state = idle ;
			break ;

		case timeoutEvt :		// TODO : manage this event specifically
			printf ("\r\nMotorCtrl: evt target Time Out !!!! pos assumed to be reached !!!") ;
			*(singleInstP->forwardClosureP) = 0 ;
			*(singleInstP->backwardClosureP) = 0 ;
			manageEvtTargetPositionReached() ;
			BNP_Ctrl::signalEvent(BNP_Ctrl::irisInitDone) ;
			state = idle ;
			break ;

		default :
			break ;
		}
		break ;

	case idle :
		printf ("\r\nMotorCtrl: state idle") ;
		switch (evt)
		{
		case newPosRequired:
			printf ("\r\nMotorCtrl: evt new pos required") ;
			startMotion();		// target pos is assumed to be initialized by BnpCtrl
			state = motionInProgress ;
			break ;

		default :				// spurrious evt
			break ;
		}
		break ;

	case motionInProgress :
		printf ("\r\nMotorCtrl: state motinInProgress") ;
		switch (evt)
		{
		case targetPositionReached:
			printf ("\r\nMotorCtrl: evt pos reached") ;
			manageEvtTargetPositionReached() ;
			BNP_Ctrl::signalEvent(BNP_Ctrl::irisPositionReached) ;
			state = idle ;
			break ;

		case timeoutEvt :
			printf ("\r\nMotorCtrl: evt timeoutEvt") ;
			// TODO : replace irisPositionReached by irisPositionTimeOut
			*(singleInstP->forwardClosureP) = 0 ;
			*(singleInstP->backwardClosureP) = 0 ;
			manageEvtTargetPositionReached() ;
			BNP_Ctrl::signalEvent(BNP_Ctrl::irisPositionReached) ;
			state = idle ;
			//manageEvtTargetPositionReached(BNP_Ctrl::irisPositionTimeOut) ;
			//initialPosition = BNP_Ctrl::irisAtCameraPostion ; // assume the further position
			//targetPosition = BNP_Ctrl::irisAtStopPosition ;
			//startMotion();
			//state = initInProgress ;
			break ;

		default :
			break ;
		}
		break ;

	default:
		break ;
	}
}
