/*
 * LedCtrl.h
 *
 *  Created on: 26 mars 2018
 *      Author: hd01073
 */

#ifndef LEDCTRL_H_
#define LEDCTRL_H_

#include "mbed.h"
#include "mbed_events.h"

#define nbTypOfActivities 6
#define NB_LED_STR1 22
#define NB_LED_STR2 46

class LedCtrl
{
public:
	static LedCtrl *singleInstP ;
	static LedCtrl &getInst(void) {
		if (!singleInstP) singleInstP = new LedCtrl() ;
				return *singleInstP ;
	};

	static void delInst(void) {
		if (singleInstP) {
			delete singleInstP ;
			singleInstP = 0 ;
		}
	} ;

	enum Evt {
		activityChangeRequired
	};

	enum Activity {
		undefinedActivity = -1,
		noActivity = 0 ,
		signalingTermIdle = 1 ,
		signalingTermSelected = 2 ,
		signalingPlugSelected = 3 ,
		signalingCharging = 4 ,
		signalingChargeSuspended = 5
	};

	void init(void) ;
	static void signalEvent(Evt evt) ;

public:
	static Activity currentActivity ;
	static Activity requiredActivity ;
//	unsigned int *frameB1 ;
//	unsigned int *frameB2 ;

private :
	LedCtrl(void) ;
	~LedCtrl() ;

	static void instanceFeedFsm(Evt evt)
	{
		singleInstP->feedFsm(evt) ;
	} ;
	void feedFsm(Evt evt) ;
	static void expirationDelayHdlr(void) ;
	static void refreshDelayHdlr(void) ;

private:
	int delayRequestId ;
	struct ActivityCtxt {				// generic context for activity
		virtual void start(void) = 0 ;
		virtual void keepAlive(void) = 0 ;
		LedCtrl &ledCtrl ;
		unsigned char lightIntensity ;
		int nbRefresh ;						// work around hardware isssue : first repaint may not work
		bool increaseIntensB ;
		ActivityCtxt(LedCtrl &_ledCtrl) :
			ledCtrl(_ledCtrl),
			lightIntensity(0),
			nbRefresh(0),
			increaseIntensB(false)
		{
		} ;
		virtual ~ActivityCtxt()
		{
		} ;
	};
	ActivityCtxt *currentActivityCtxtP ;

	struct NoActivityCtxt :
		public ActivityCtxt {		// specific context
		NoActivityCtxt (LedCtrl &_ledCtrl) ;
		virtual ~NoActivityCtxt() {} ;
		virtual void start(void) ;
		virtual void keepAlive(void) ;
	}  ;

	struct SignalingTermIdleCtxt :
		public ActivityCtxt {		// specific context
		SignalingTermIdleCtxt (LedCtrl &_ledCtrl) ;
		virtual ~SignalingTermIdleCtxt() {} ;
		virtual void start(void) ;
		virtual void keepAlive(void) ;
	} ;

	struct SignalingTermSelectedCtxt :
		public ActivityCtxt {
		SignalingTermSelectedCtxt(LedCtrl &_ledCtrl) ;
		virtual ~SignalingTermSelectedCtxt()  {} ;
		virtual void start(void) ;
		virtual void keepAlive(void) ;

	} ;

	struct SignalingPlugSelectedCtxt :
		public ActivityCtxt {
		SignalingPlugSelectedCtxt(LedCtrl &_ledCtrl) ;
		virtual ~SignalingPlugSelectedCtxt()  {} ;
		virtual void start(void) ;
		virtual void keepAlive(void) ;
	} ;

	struct SignalingChargingCtxt :
		public ActivityCtxt {
		int startIdxStr1 ;
		int startIdxStr2 ;
		SignalingChargingCtxt(LedCtrl &_ledCtrl) ;
		virtual ~SignalingChargingCtxt()  {} ;
		virtual void start(void) ;
		virtual void keepAlive(void) ;
	} ;

	struct SignalingChargeSuspendedCtxt :
		public ActivityCtxt {
		SignalingChargeSuspendedCtxt(LedCtrl &_ledCtrl) ;
		virtual ~SignalingChargeSuspendedCtxt()  {} ;
		virtual void start(void) ;
		virtual void keepAlive(void) ;
	} ;

	NoActivityCtxt noActivityCtxt ;
	SignalingTermIdleCtxt signalingTermIdleCtxt ;
	SignalingTermSelectedCtxt signalingTermSelectedCtxt ;
	SignalingPlugSelectedCtxt signalingPlugSelectedCtxt ;
	SignalingChargingCtxt signalingChargingCtxt ;
	SignalingChargeSuspendedCtxt signalingChargeSuspendedCtxt ;

	ActivityCtxt *ctxtAP[nbTypOfActivities] ;
};


#endif /* LEDCTRL_H_ */
