/*
 * BltLink.h
 *
 *  Created on: 24 mars 2018
 *      Author: hd01073
 */

#ifndef BLTLINK_H_
#define BLTLINK_H_

#include "mbed.h"
#include "mbed_events.h"
#include "ble/BLE.h"
#include "ble/services/UARTService.h"
#include "BNP_Ctrl.h"

class BltLink
{
public :
	static BltLink *singleInstP ;
	static BltLink &getInst(void) {
		if (!singleInstP) singleInstP = new BltLink() ;
		return *singleInstP ;
	} ;
	static void delInst(void) {
		if (singleInstP) {
			delete singleInstP ;
			singleInstP = 0 ;
		}
	} ;
	static void printMacAddress(void) ;
	void init(void) ;

public:
	bool connectedB ;
	int8_t rssi ;
	BNP_Ctrl::IrisPosition selectedIrisPosition ;

private:
	static void connectionCallback(const Gap::ConnectionCallbackParams_t *params) ;
	static void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) ;

	BltLink (void) :
		connectedB (false),
		rssi(0),
		selectedIrisPosition(BNP_Ctrl::irisNoPostion),
		connectionHandle(0)
	{
		led1P = new DigitalOut (LED1) ;
		init() ;
	} ;

	~BltLink()
	{
		delete led1P ;
		delete uartServicePtr ;
	} ;

private:
//	static void updateRssi(void) ;
	static void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context) ;

private:
	Gap::Handle_t connectionHandle;
	DigitalOut *led1P ;
	UARTService *uartServicePtr ;
};


#endif /* BLTLINK_H_ */
