/* 
 * 
 */
#include "mbed.h"
#include "mbed_events.h"
#include "BltLink.h"
#include "LedCtrl.h"
#include "MotorCtrl.h"
#include "Audio.h"

#ifdef DEBUG
#define PRINTF(...) { printf(__VA_ARGS__); }
#else
#define PRINTF(...)
#endif

EventQueue *mainQueueP ;


int main(void)
{
	mainQueueP = new EventQueue (256 * EVENTS_EVENT_SIZE) ;

	BNP_Ctrl &bnpCtrl = BNP_Ctrl::getInst() ;
	bnpCtrl.init() ;

	BltLink &bltLink = BltLink::getInst() ;
	bltLink.init() ;

	LedCtrl &ledCtrl = LedCtrl::getInst() ;
	ledCtrl.init() ;

	MotorCtrl &motorCtrl = MotorCtrl::getInst() ;
	motorCtrl.init() ;

	Audio::init() ;
	
	printf ("\r\nmain: build 4/16/18 16:15 - start event dispatch\r\n") ;
    mainQueueP->dispatch_forever();

    return 0 ;
}


