/*
 * BNP_Ctrl.cpp
 *
 *  Created on: 23 mars 2018
 *      Author: hd01073
 */

#include <stdio.h>
#include "mbed.h"
#include "mbed_events.h"
#include "BNP_Ctrl.h"
#include "MotorCtrl.h"
#include "LedCtrl.h"
#include "BltLink.h"
#include "Audio.h"

// 0.33  ==> 1000 Watt @220V
#define POWER_IN_WATT_AT_220V 5.0		// adjusted to my air fan !!
#define HALL_TRESHOLD	((0.33/1000.0) * POWER_IN_WATT_AT_220V)

#define RELAY_PLUG_E_PIN_ID     PG_4
#define RELAY_PLUG_C_PIN_ID     PG_5
#define RELAY_CLOSING_PIN_VALUE 0
#define RELAY_OPENING_PIN_VALUE 1


DigitalOut *plugE_P = 0 ;	// ne fonctionne pas au 31/03/18 ==> on utilise plugC 
DigitalOut *plugC_P = 0 ;
AnalogIn *hallSensorP = 0  ;


BNP_Ctrl *BNP_Ctrl::singleInstP = 0 ;


void BNP_Ctrl::signalEvent(Evt evt)
{
	mainQueueP->call(instanceFeedFsm, evt) ;
}

void BNP_Ctrl::init(void)
{
	if (!plugE_P) {
		plugE_P = new DigitalOut (RELAY_PLUG_E_PIN_ID) ;    // relai ok au 31/03/18
	}
	if (!plugC_P) {
		plugC_P = new DigitalOut (RELAY_PLUG_C_PIN_ID) ;	// relai ok au 31/03/18
	}
	if (!hallSensorP) {
		 hallSensorP = new AnalogIn (PB_1) ;
	}

	*plugE_P = RELAY_OPENING_PIN_VALUE ;		// attention : logique negative. 1 ==> relais ouvert
	*plugC_P = RELAY_OPENING_PIN_VALUE ;
	state = initInProgress ;
}

void BNP_Ctrl::plugConnectDetect(void)
{
	float voltageHallSensor = *hallSensorP ;
	if ((double)voltageHallSensor > HALL_TRESHOLD) {	
		singleInstP->feedFsm(currentDetected) ;
	}
}


void BNP_Ctrl::plugDisconnectDetect(void)
{
	float voltageHallSensor = *hallSensorP ;
	if ((double)voltageHallSensor < HALL_TRESHOLD) {	
		singleInstP->feedFsm(currentInterrupted) ;
	}
}


void BNP_Ctrl::plugConnectTimeoutHdlr(void)
{
	singleInstP->feedFsm(timeoutFired) ;
}


void BNP_Ctrl::internalDelayExpiredHdlr(void)
{
	singleInstP->feedFsm(delayExpired) ;
}


void BNP_Ctrl::feedFsm(Evt evt)
{
	switch (state) {
	case initInProgress:
		printf ("\r\nBNP_Ctrl: state initInProgress") ; 
		switch (evt) {
		case irisInitDone :
			printf ("\r\nBNP_Ctrl: evt irisInitDone") ;
			LedCtrl::requiredActivity = LedCtrl::signalingTermIdle ;
			LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
			state = idleWithLed;
			break ;
		default:				// spurious evt
			break ;
		}
		break ;


	case idleNoLed :
	case idleWithLed :
		printf ("\r\nBNP_Ctrl: state Idle") ;
		switch (evt) {
		case oprTerminalReserve :
			printf ("\r\nBNP_Ctrl: evt oprTerminalReserve")  ;
			LedCtrl::requiredActivity = LedCtrl::signalingTermSelected ;
			LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
			state = terminalSelected ;
			break ;
		default:				// spurious evt
			break ;
		}
		break ;


	case terminalSelected :
		printf ("\r\nBNP_Ctrl: state terminalSelected") ;
		switch (evt) {
		case oprPlugSelection :
			printf ("\r\nBNP_Ctrl: evt oprPlugSelection") ;
			LedCtrl::requiredActivity = LedCtrl::signalingPlugSelected ;
			LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
			MotorCtrl::getInst().targetPosition = BltLink::getInst().selectedIrisPosition ;
			MotorCtrl::signalEvent(MotorCtrl::newPosRequired) ;
			state = plugPresentationInProgress;
			break ;
		default:				// spurious evt
			break ;
		}
		break ;

	case plugPresentationInProgress:
		printf ("\r\nBNP_Ctrl: state plugPresentationInProgress") ;
		switch (evt) {
		case irisPositionReached :
			printf ("\r\nBNP_Ctrl: evt irisPos reached") ;
			if (MotorCtrl::getInst().targetPosition == irisAtPlugEPosition) {
				*plugE_P = RELAY_CLOSING_PIN_VALUE ;	
				Audio::startPlay(trackPlugE) ;
			} else {
				*plugC_P = RELAY_CLOSING_PIN_VALUE ;
				Audio::startPlay(trackPlugC) ;
			}
			autoRepeatTimerId = mainQueueP->call_every(500, plugConnectDetect) ;
			timeoutId = mainQueueP->call_in (30000, plugConnectTimeoutHdlr) ;
			state = waitingPlugConnection ;
			break ;
		default:				// spurious evt
			break ;
		}
		break ;

	case waitingPlugConnection:
		printf ("\r\nBNP_Ctrl: state waitingPlugConnection") ;
		switch (evt) {
		case currentDetected :
			printf ("\r\nBNP_Ctrl: evt current detect") ;
			mainQueueP->cancel(autoRepeatTimerId) ;
			autoRepeatTimerId = 0 ;
			mainQueueP->cancel(timeoutId) ;
			timeoutId = 0 ;
			LedCtrl::requiredActivity = LedCtrl::signalingCharging ;
			LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
			autoRepeatTimerId = mainQueueP->call_every(500, plugDisconnectDetect) ;
			state = chargingInProgress ;
			break ;

		case timeoutFired :
			printf ("\r\nBNP_Ctrl: timeout fired") ;
			mainQueueP->cancel(autoRepeatTimerId) ;
			autoRepeatTimerId = 0 ;
			mainQueueP->cancel(timeoutId) ;
			timeoutId = 0 ;
			if (MotorCtrl::getInst().targetPosition == irisAtPlugEPosition) {
				*plugE_P = RELAY_OPENING_PIN_VALUE;	
			} else {
				*plugC_P = RELAY_OPENING_PIN_VALUE ; 
			}
			LedCtrl::requiredActivity = LedCtrl::signalingChargeSuspended ;
			LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
			MotorCtrl::getInst().targetPosition = BNP_Ctrl::irisAtShieldPosition ;
			MotorCtrl::signalEvent(MotorCtrl::newPosRequired) ;
			state = shieldPresentationInProgress ;
			break ;

		default:				// spurious evt
			break ;
		}
		break ;

	case chargingInProgress:
		printf ("\r\nBNP_Ctrl: state chargin") ;
		switch (evt) {
		case currentInterrupted :
			printf ("\r\nBNP_Ctrl: evt no current") ;
			mainQueueP->cancel(autoRepeatTimerId) ;
			autoRepeatTimerId = 0 ;
			if (MotorCtrl::getInst().targetPosition == irisAtPlugEPosition) {
				*plugE_P = RELAY_OPENING_PIN_VALUE ;	
			} else {
				*plugC_P = RELAY_OPENING_PIN_VALUE ; 
			}
			LedCtrl::requiredActivity = LedCtrl::signalingChargeSuspended ;
			LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
			MotorCtrl::getInst().targetPosition = BNP_Ctrl::irisAtShieldPosition ;
			MotorCtrl::signalEvent(MotorCtrl::newPosRequired) ;
			state = shieldPresentationInProgress ;
			break ;

		default:				// spurious evt
			break ;
		}

		break ;

	case shieldPresentationInProgress:
		printf ("\r\nBNP_Ctrl: shield present in progress") ;
		switch (evt) {
		case irisPositionReached :
		case irisPositionTimeOut :			// !!! TODO : manage this event separately
			printf ("\r\nBNP_Ctrl: evt pos reached or to") ;
			delayId = mainQueueP->call_in (60000, internalDelayExpiredHdlr) ;
			state = chargingSuspended ;
			break ;

		default:
			break ;
		}

		case chargingSuspended:
			printf ("\r\nBNP_Ctrl: state charge suspend") ;
			switch (evt) {
			case delayExpired :
				printf ("\r\nBNP_Ctrl: evt delay expired") ;
				delayId = 0 ;
				LedCtrl::requiredActivity = LedCtrl::signalingTermIdle ;
				LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
				state = idleWithLed;
				break ;

			case oprResumptionRequest :
				printf ("\r\nBNP_Ctrl: evt resume request") ;
				mainQueueP->cancel(delayId) ;
				Audio::startPlay(trackResumption) ;
				LedCtrl::requiredActivity = LedCtrl::signalingPlugSelected ;
				LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
				MotorCtrl::getInst().targetPosition = BltLink::getInst().selectedIrisPosition ;
				MotorCtrl::signalEvent(MotorCtrl::newPosRequired) ;
				state = plugPresentationInProgress;
				break ;

			case oprTerminalRelease:
				printf ("\r\nBNP_Ctrl: evt oprTerminalRelease") ;
				delayId = 0 ;
				LedCtrl::requiredActivity = LedCtrl::signalingTermIdle ;
				LedCtrl::signalEvent(LedCtrl::activityChangeRequired) ;
				state = idleWithLed;
				break ;


			default:
				break ;
			}
			break ;

		default :
			printf ("!!!! ERROR - BNP_Ctrl::feedFsm\n\r") ;
			break ;
	}
}
