/*
 * Audio.cpp
 *
 *  Created on: 28 mars 2018
 *      Author: hd01073
 */

#include "Audio.h"
#include "BNP_Ctrl.h"

#ifdef AUDIO_OPT

extern EventQueue *mainQueueP ;

soundboard mySoundBoard(PG_3, PB_6, PG_2, PE_14);
Ticker soundTick ;

BNP_Ctrl::AudioTrack Audio::demandedTrack = BNP_Ctrl::noTrack ;
Audio::State Audio::state = Audio::noState ;


soundboard::soundboard(PinName resetPin, PinName clockPin, PinName dataPin, PinName busyPin) : 
_resetPin(resetPin), _clockPin(clockPin), _dataPin(dataPin), _busyPin(busyPin),
resetState(0), cmdState(0)
{
}

void soundboard::startReset()
{
    printf ("\r\nsoundboard::reset()\n") ;
    soundTick.detach() ;
    _clockPin = 0;
   	_resetPin = 1;
    resetState = 1 ;
    soundTick.attach_us(singleInstManageReset, 200) ;
}


void soundboard::singleInstManageReset(void) 
{
	mySoundBoard.manageReset() ;
}


void notifySoundResetComplete(void) 
{
	printf ("\r\nReset ended\r\n") ;
	Audio::feedFsm(Audio::soundResetComplete) ;
}


void notifySoundResetErr(void) 
{
	printf ("\r\nReset error !!!\r\n") ;
} 

void soundboard::manageReset(void)
{
    switch (resetState) {
    	case 1 :
    	//Reset pulse.
    	_resetPin = 0;
     	resetState = 2 ;
     	soundTick.detach() ;
     	soundTick.attach_us(soundboard::singleInstManageReset, 5000) ;
    	return ;
    	
	    case 2 :
    	_resetPin = 1;
    	//Reset idle to start bit.
    	_clockPin = 1;
    	resetState = 3 ;
     	soundTick.detach() ;
     	soundTick.attach(soundboard::singleInstManageReset, 0.3) ;
    	return ;
    	
    	case 3:
     	soundTick.detach() ;
     	mainQueueP->call(notifySoundResetComplete) ;
    	resetState = 0 ;
    	return ;
    	
    	default :
     	soundTick.detach() ;
   		mainQueueP->call(notifySoundResetErr) ;
    	resetState = 0 ;
	   	return ;
    }
}


void soundboard::singleInstManageCmd(void) 
{
	mySoundBoard.manageCmd() ;
}


void soundboard::startCommand(unsigned int cmd)
{
    printf ("\r\nsoundboard::startCommand(0x%04x)\n", cmd) ;
	_cmd = cmd ;
	cmdState = 1 ;
	soundTick.detach() ;
	manageCmd() ;
}
	
void notifySoundCmdSent(void) 
{
	printf ("\r\nEnd sound cmd\n") ;
	Audio::feedFsm(Audio::soundCmdSent) ;
}

void notifySoundCmdErr(void) 
{
	printf ("\r\nSound cmd err !!!\n") ;
}

void soundboard::manageCmd(void)
{
    switch (cmdState) {
    	case 1 :
    	_clockPin = 0;
    	cmdState = 2 ;
       	soundTick.attach_us(soundboard::singleInstManageCmd, 2000) ;
    	return ;
    	
    	case 2 :
    	soundTick.detach() ;
    	soundTick.attach_us(soundboard::singleInstManageCmd, 200) ;
    	_mask = 0x8000 ;
    	cmdState = 3 ;
    	return ;
    	
    	case 3 :
    	if (_mask == 0) {
    		cmdState = 0 ;
    		soundTick.detach() ;
    		mainQueueP->call(notifySoundCmdSent) ;
    		return ;
    	}
    	_clockPin = 0 ;
    	cmdState = 4 ;
    	return ;
    	
    	case 4 :
        if(_cmd & _mask){
            _dataPin = 1;
        } else {
            _dataPin = 0;
        };
        cmdState = 5 ;
        return ;
        
        case 5:
        _clockPin=1;
        _mask >>= 1 ;
    	cmdState = 3 ;
    	return ;
    	    	
    	default : 
     	cmdState = 0 ;
    	soundTick.detach() ;
   		mainQueueP->call(notifySoundCmdErr) ;
    	return ;
    }
}


void Audio::startPlay(BNP_Ctrl::AudioTrack track)
{
	if ((state == idle) && (demandedTrack == BNP_Ctrl::noTrack)) {
		demandedTrack = track ;
		Audio::feedFsm(newJingleRequired) ;
	} else {
		printf ("\r\nAudio::play(): error: audio busy, request given-up\n") ;
	}
}


void Audio::init(void)
{
	if (state == noState)  {
		Audio::feedFsm(noEvt) ;
	} else {
		printf ("\r\nAudio::init(): error: inconsistent state\n") ;
	}
}

void soundCardNotBusySimulation(void) 
{
	Audio::feedFsm(Audio::soundNotBusy) ;
}


void Audio::feedFsm(Evt evt)
{
	switch (state) {
		case noState :	
		mySoundBoard.startReset() ;
		state = soundResetInProgress ; 
		return ;
		
		case soundResetInProgress :				// evt soundResetComplet assumed
		mySoundBoard.startCommand(VOL_7) ;
		state = sendingVolCmd ;
		return ;
		
		case sendingVolCmd :					// evt soundCmdSent assumed
		state = waitingVolCmdComplete ;
		mainQueueP->call_in(500, soundCardNotBusySimulation) ;
		return ;
		
		case waitingVolCmdComplete :			// evt Sound Not Busy
		state = idle ;
		return ;
		
		case idle :								// evt new jingle required
		printf ("\r\nmySoundBoard.startCmd(%d)", demandedTrack) ;
		mySoundBoard.startCommand((unsigned int)demandedTrack) ;
		state = sendingPlayCmd ;
		return ;
		
		case sendingPlayCmd :					// evt soundCmdSent 
		printf ("\r\naudio cmd %d sent\n", demandedTrack) ;
		state = waitingPlayCmdComplete ;
		mainQueueP->call_in(5000, soundCardNotBusySimulation) ;
		return ;
		
		case waitingPlayCmdComplete :			// evt sound not busy
		printf ("\r\naudio jingle %d played\n", demandedTrack) ;
		demandedTrack = BNP_Ctrl::noTrack ;
		state = idle ;
		return ;
		
		default :
		printf ("\r\naudio:err: inconsistent state !!!!") ;
		state = idle ;
		return ;
		
	}
}

#else

void Audio::init(void)
{
}

void Audio::startPlay(BNP_Ctrl::AudioTrack track)
{
}

#endif