#include "mbed.h"
#include "MODSERIAL.h"
#define SERIAL_BAUD 115200 // boud rate for serial communication
// This program controls the stepper motor

// Serial communication using MODSERIAL
MODSERIAL pc(USBTX,USBRX);

// Set LED pins
DigitalOut led(LED_RED);

// Setup motor pins
// DigitalOut pinMode(PTD2); //D11 NOW USES 3.3V OUPUT, SINCE THIS IS ALWAYS ON
DigitalOut pinSleep(PTE24);      //D14
DigitalOut pinStep(PTC4);        //D9
DigitalOut pinDir(PTC12);        //D8

// Control of the stepper motor with 1 Ticker and 1 Timeout
Ticker  TickerStepper;
Timeout TimeoutStepper;

// Set button In
InterruptIn button1(PTB9); // D2
InterruptIn button2(PTA1); // D3

// Set constans
volatile int stepmode = 4; // step mode
volatile int steps = 140*stepmode; // amount of steps for 90 degree rotation = 50, full step mode: 1.8 degree per step.
volatile int i = 0;
volatile bool Stepper_CCW = false;

// Global variable Step_State
volatile bool Stepper_State = 0;

// Set the Step pin to 0
void StepperFall()
{
    pinStep = 0;
}
// Turn off stepper and power off driver board. Reset Stepper_CCS, i and Stepper_State
void Stepper_Off()
{
    TickerStepper.detach();
    pinSleep = 0;
    i=0;
    Stepper_State = 0;
    Stepper_CCW = false;
}

// Change direction
void Stepper_Change_Dir()
{
    pinDir = true;
    Stepper_CCW = true;
    i = 0; 
}

// Move the motor 1 step
void StepperRise()
{
    if((i<steps)&&(not Stepper_CCW))
    {
        pinStep=1; // Set stepper to 1
        // attach timeout to set it back to 0, min step duration is 1.8 us
        TimeoutStepper.attach_us(&StepperFall, 2);
        i=i+1;
    }
    else if (Stepper_CCW)
    {
        if(i<steps)
        {
            pinStep=1;
            TimeoutStepper.attach_us(&StepperFall, 2);
            i=i+1;
        }
        else 
        {
            Stepper_Off();
        }
    }
    else
    {
         Stepper_Change_Dir();
    }
}

// Activate the stepper motor
// at a constant speed
void Stepper_On()
{
    // Set global variable to true
    Stepper_State = true;
    // Power on the board and set direction to CW
    pinSleep = 1;
    pinDir = false;
    // Calc the speed of the stepper
    int nPPS = 50*stepmode;  // was 1200, this controlls the speed, keep this times the step mode
    float fFrequency_Hz = 1.f * nPPS;
    float fPeriod_s = 1.0f / fFrequency_Hz;
    // Check if the speed is too fast small and report back if that is the case
    if (fPeriod_s < 2e-6)
    {
        pc.printf("\r\n ERROR: fPeriod_s too small \r\n");
        fPeriod_s=2e-6;
    }    
    
    TickerStepper.attach(&StepperRise, // void(*fptr)(void)
                        fPeriod_s   // float t
                        );
}



// Deactivate the motor
void BlinkLed()
{
    led = not led;
}

int main()
{
    // Power on the board
    pinSleep = 0;

    // Set baud connection with PC
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n ***THERMONUCLEAR WARFARE COMMENCES*** \r\n");
    
    // Setup Blinking LED
    led = 1;
    Ticker TickerBlinkLed;
    TickerBlinkLed.attach(BlinkLed,0.5);
    
    // Setup interruptin
    button1.fall(&Stepper_On);
    
    // Make the stepper go
    while(true){
    }
}