#include "mbed.h"
#include "HIDScope.h"
 
// Define the HIDScope and Ticker object
HIDScope    scope(1);
Ticker      scopeTimer;
 
// Read the analog input
AnalogIn    a0(A0);

// Set LED out
DigitalOut  led(LED_RED);
 
const float kTimeLedToggle = .5f;  // period of blinking
const int   kLedOn=0;             // Led on if 0
 
// The data read and send function
void scopeSend()
{
    scope.set(0, a0.read());
    scope.send();
}

void SwitchLed(){
    led = not led;
}
 
int main()
{
    led = not kLedOn;
    
    // Create ticker for LED and attach
    Ticker tick_toggle_led;
    tick_toggle_led.attach(SwitchLed,kTimeLedToggle);
    
    // Attach the data read and send function at 100 Hz
    scopeTimer.attach(scopeSend, 1e4);
   
    while(true);
}