#include "mbed.h"
#define SERIAL_BAUD 115200  // baud rate for serial communication
#include "FastPWM.h"

// This program controlls the brightness of a LED using PWM with the potmeter as input

// Serial connection with PC
Serial pc(USBTX,USBRX);

// Led
FastPWM led(D7);

// PotmeterIn
AnalogIn pot(A0);

// Initial duty value and period
volatile float duty = 0.0;
volatile float frequency_pwm = 100.0;
const int Timeset_duty_cycle = 50;

void set_dutycycle() {
    duty=pot.read();
    pc.printf("\r\n Potvalue = %f \r\n",duty);
    led.write(duty/3);
    }

int main()
{
    // Set baud connection with PC
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n ***THERMONUCLEAR WARFARE COMMENCES*** \r\n");
    
    // Make tickers and attach
    Ticker tick_set_brightness;
    tick_set_brightness.attach(set_dutycycle,1/Timeset_duty_cycle);
    
    // Set period of LED
    led.period(1.0/frequency_pwm);
    
    while(true){
        
    };
}