#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"
#define SERIAL_BAUD 115200  // baud rate for serial communication
 
Serial pc(USBTX,USBRX);

int countsCW = 0;
int countsCCW = 0;
int net_counts = 0;
float degrees = 0.0;
const float counts_per_rev = 4200.0;
QEI EncoderCW(D12,D13,NC,32);
QEI EncoderCCW(D13,D12,NC,32);

void PrintDegrees(){
    pc.printf("\r\n Nett Pulses %i \r\n", net_counts);
    pc.printf("\r\n Output degrees  %f \r\n", degrees);
    }

int main()
{
    pc.baud(SERIAL_BAUD);
    pc.printf("\r\n ***THERMONUCLEAR WARFARE COMMENCES*** \r\n");
    
    // Set ticker for serial communication of counts and degrees
    Ticker PrintDegreesTicker;
    PrintDegreesTicker.attach(&PrintDegrees,0.1);
    
    // count the CW and CCW counts and calculate the output degrees
    while(true){
    countsCW = EncoderCW.getPulses();
    countsCCW= EncoderCCW.getPulses();
    net_counts=countsCW-countsCCW;
    degrees=(net_counts*360.0)/counts_per_rev;
    
    }
}