#include "mbed.h"

double Kp = 7.5;
double Ki = 1.02;
double Kd = 10;
extern double samplingfreq = 1000;

void PID_controller(double error1, double error2, float &u1, float &u2)
{  
    double u_k = Kp * error1;
    
    static double error_integral = 0;
    static double error_prev = error1; // initialization with this value only done once!
    static BiQuad LowPassFilter(0.0640, 0.1279, 0.0640, -1.1683, 0.4241);
    
    error_integral = error_integral + error1 * 1/samplingfreq;
    double u_i = Ki * error_integral;
    
    double error_derivative = (error1 - error_prev)*samplingfreq;
    double filtered_error_derivative = LowPassFilter.step(error_derivative);
    double u_d = Kd * filtered_error_derivative;
    error_prev = error1;
    u1 =  u_k+u_i+u_d;
}