#include "mbed.h"
#include "BiQuad.h"

//Define objects

// filter chains for high pass, low pass and notch filters
BiQuadChain bqc0;
BiQuadChain bqc1;
BiQuadChain bqc2;
BiQuadChain bqc3;

// Filters for sampling frequency 1000 Hz

// emg signal 0 filters
//BiQuad bq0low( 0.3913/10000.0, 0.7826/10000.0, 0.3913/10000.0, -1.9822, 0.9824); // 2 Hz cutoff
BiQuad bq0low( 0.0877/1000.0, 0.1753/1000.0, 0.0877/1000.0, -1.9733, 0.9737); // 3 Hz cutoff
//BiQuad bq0low( 0.3460/1000.0, 0.6921/1000.0, 0.3460/1000.0, -1.9467, 0.9481); // 6 Hz cutoff
BiQuad bq0high( 0.9150, -1.8299, 0.9150, -1.8227, 0.8372);  //cutoff at 20 Hz
BiQuad bq0notch( 0.9695, -1.8442, 0.9695, -1.8442, 0.9391); //notch 50 Hz
BiQuad bq0notch2( 0.9695, -1.5687, 0.9695, -1.5687, 0.9391);//notch 100 Hz
BiQuad bq0notch3( 0.9695, -1.1398, 0.9695, -1.1398, 0.9391);//notch 150 Hz
BiQuad bq0notch4( 0.9695, -0.5992, 0.9695, -0.5992, 0.9391);//notch 200 Hz

// emg signal 1 filters
//BiQuad bq1low( 0.3913/10000.0, 0.7826/10000.0, 0.3913/10000.0, -1.9822, 0.9824); // 2 Hz cutoff
BiQuad bq1low( 0.0877/1000.0, 0.1753/1000.0, 0.0877/1000.0, -1.9733, 0.9737); // 3 Hz cutoff
//BiQuad bq1low( 0.3460/1000.0, 0.6921/1000.0, 0.3460/1000.0, -1.9467, 0.9481); // 6 Hz cutoff
BiQuad bq1high( 0.9150, -1.8299, 0.9150, -1.8227, 0.8372);  //cutoff at 20 Hz
BiQuad bq1notch( 0.9695, -1.8442, 0.9695, -1.8442, 0.9391); //notch 50 Hz
BiQuad bq1notch2( 0.9695, -1.5687, 0.9695, -1.5687, 0.9391);//notch 100 Hz
BiQuad bq1notch3( 0.9695, -1.1398, 0.9695, -1.1398, 0.9391);//notch 150 Hz
BiQuad bq1notch4( 0.9695, -0.5992, 0.9695, -0.5992, 0.9391);//notch 200 Hz

// emg signal 2 filters
//BiQuad bq2low( 0.3913/10000.0, 0.7826/10000.0, 0.3913/10000.0, -1.9822, 0.9824); // 2 Hz cutoff
BiQuad bq2low( 0.0877/1000.0, 0.1753/1000.0, 0.0877/1000.0, -1.9733, 0.9737); // 3 Hz cutoff
//BiQuad bq2low( 0.3460/1000.0, 0.6921/1000.0, 0.3460/1000.0, -1.9467, 0.9481); // 6 Hz cutoff
BiQuad bq2high( 0.9150, -1.8299, 0.9150, -1.8227, 0.8372);  //cutoff at 20 Hz
BiQuad bq2notch( 0.9695, -1.8442, 0.9695, -1.8442, 0.9391); //notch 50 Hz
BiQuad bq2notch2( 0.9695, -1.5687, 0.9695, -1.5687, 0.9391);//notch 100 Hz
BiQuad bq2notch3( 0.9695, -1.1398, 0.9695, -1.1398, 0.9391);//notch 150 Hz
BiQuad bq2notch4( 0.9695, -0.5992, 0.9695, -0.5992, 0.9391);//notch 200 Hz

// emg signal 3 filters
//BiQuad bq3low( 0.3913/10000.0, 0.7826/10000.0, 0.3913/10000.0, -1.9822, 0.9824); // 2 Hz cutoff
BiQuad bq3low( 0.0877/1000.0, 0.1753/1000.0, 0.0877/1000.0, -1.9733, 0.9737); // 3 Hz cutoff
//BiQuad bq3low( 0.3460/1000.0, 0.6921/1000.0, 0.3460/1000.0, -1.9467, 0.9481); // 6 Hz cutoff
BiQuad bq3high( 0.9150, -1.8299, 0.9150, -1.8227, 0.8372);  //cutoff at 20 Hz
BiQuad bq3notch( 0.9695, -1.8442, 0.9695, -1.8442, 0.9391); //notch 50 Hz
BiQuad bq3notch2( 0.9695, -1.5687, 0.9695, -1.5687, 0.9391);//notch 100 Hz
BiQuad bq3notch3( 0.9695, -1.1398, 0.9695, -1.1398, 0.9391);//notch 150 Hz
BiQuad bq3notch4( 0.9695, -0.5992, 0.9695, -0.5992, 0.9391);//notch 200 Hz


void processing_chain_emg(double &raw_emg_0, double &raw_emg_1, double &raw_emg_2, double &raw_emg_3, double &process_emg_0, double &process_emg_1, double &process_emg_2, double &process_emg_3) {
    
    // we first filter high pass and notch, then rectifier and after that low pass
    process_emg_0 = bq0low.step(fabs(bqc0.step( raw_emg_0 )));
    process_emg_1 = bq1low.step(fabs(bqc1.step( raw_emg_1 )));
    process_emg_2 = bq2low.step(fabs(bqc2.step( raw_emg_2 )));
    process_emg_3 = bq3low.step(fabs(bqc3.step( raw_emg_3 )));
    
}

