//****************************************************************** Encoder Script ******************************************************************
// In this script there will be looked at how we can calculate the degrees that a pulomo DC motor with a gearbox 1:131 kan make. 
// The usage of this script will be explained in Steps by 
// Author: Robert v/d Wal, Lisa Verhoeven, Thijs van der Wal, Ewoud Velu, Emily Zoetbrood

// ******************************************* Library DECLARATION **************************************
// We need to add the standard "mbed.h" library for standard commands. 
// The second library is used to read the encoder on the DC motor. If you look at the library you see a command with QEI wheel. This needs information
// of how many Inputs are measuring the Encoder(2 in this script other is NC). We want to read it with a known reading speed and that is 64 bit, 
// the last thing is if the encoder works with X1, X2 or X4 encoding.
#include "mbed.h"
#include "QEI.h"
#include "MODSERIAL.h"

// ******************************************* FUNCTION DECLA *******************************************
Serial pc(USBTX, USBRX);
DigitalOut motor2direction(D4); //D4 en D5 zijn motor 2 (op het motorshield)
PwmOut motor2speed(D5);
QEI wheel (D11, D12, NC, 64,QEI::X4_ENCODING);       //

//***************************** Variables DECLA *****************

bool flag_1 = false; 

// ************************** TICKER DECLA ****************
Ticker flipper;

//*****************************************************************************************************************************************************************



//********    SCRIPT     **************
void flip()
{
    flag_1 = true;
}



int main()
{

    flipper.attach(&flip, 0.01);            // 100 HZ is the samplefrequency to read the encoder 
    while(1) {
        motor2direction.write(0);
        motor2speed.write(0.2);
        wait(0.1);
        if(flag_1 == true) 
        {
        pc.printf("Pulses is: %i\n", (wheel.getPulses()/((64*131)/360)));                // The reading of the Encoder 
        flag_1 = false;  
        }                                                                // set if loop off
    }

}

// *****Explanation script******
// You don't need to look at the Ticker or the motor settings but only on the command "wheel.getPulses()".
// With this command you can read how many pulses are being read. To read it you can set a Ticker to constant read the value.
// Warning!!! The encoder input gets in a formula to calculate the degrees the encoder is making in the "pc.printf" loop,
// but if you want to use this formula in signal processing you get a problem. C++ cannot work with a Input and formula processing at 
// the same time so get first Input and then set this known value in a formula.