#include "mbed.h"

Serial pc(USBTX, USBRX);


// Define pins for motor control
//horizontal motor
DigitalOut directionPin(D4);
PwmOut PWM(D5);
//keypress motor
DigitalOut directionPin_key(D7);
PwmOut PWM_key(D6);

//button to press the key
DigitalIn button_key(PTC6);
DigitalIn button_song(PTA4);

//pot meters to act as emg filter substitutes
AnalogIn left_pot(A0);
AnalogIn right_pot(A1);

//variables to hold the values of the pot meters
double emg_left;
double emg_right;

//int to check if the button is pressed
const int Button_move_pressed = 0;
const int Button_song_pressed = 0;

//values for clockwise and counter clockwise movement
const int cw = 1;
const int ccw = 0;



int main()
{
    while(1) {
        pc.printf("at the begin");
        
        //read the 'emg' values
        emg_left = left_pot.read();
        emg_right = right_pot.read();
        
        //if left above threashold and right below; move left
        while (emg_left > 0.5 and emg_right < 0.5)
        {
            directionPin.write(cw);
            PWM.write(1);
            //new left value to check (in while loop condition) if it has fallen below threashold
            emg_left = left_pot.read();
            pc.printf("left \n");
        }
        
        while (emg_right > 0.5 and emg_left < 0.5)
        {
            directionPin.write(ccw);
            PWM.write(1);
            //new right value, to check in while loop condition
            emg_right = right_pot.read();
            pc.printf("right \n");
        }
        if (button_key.read() == Button_move_pressed)
        {
            //move to key
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            pc.printf("keypress \n");
            
        }
        
        /// set spped values of both motors to zero so if no muscles are contracted, no motors move
        //more of a safety catch than actually necessary
        PWM_key.write(0);
        PWM.write(0);
        
        //cw to the right
         if (button_song.read() == Button_song_pressed){
             
                //pressing va
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
             
             // go 1 key to right
             directionPin.write(cw);
             PWM.write(1);
             wait(2.2);
             PWM.write(0);
              
               //pressing der
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
             
             // go 1 key to right
             directionPin.write(cw);
             PWM.write(1);
             wait(2.2);
             PWM.write(0);
             
                //pressing ja 
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
            
             // go 2 key to left
             directionPin.write(ccw);
             PWM.write(1);
             wait(4.5);
             PWM.write(0);
             
                   //pressing cob 
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
            
             wait(1.5);
             
                  //pressing va
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
             
             // go 1 key to right
             directionPin.write(cw);
             PWM.write(1);
             wait(2.2);
             PWM.write(0);
              
               //pressing der
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
             
             // go 1 key to right
             directionPin.write(cw);
             PWM.write(1);
             wait(2.2);
             PWM.write(0);
             
                //pressing ja 
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
            
             // go 2 key to left
             directionPin.write(ccw);
             PWM.write(1);
             wait(4.5);
             PWM.write(0);
             
                   //pressing cob 
            directionPin_key.write(cw);
            PWM_key.write(1);
            wait(0.14); //time it takes pwm of one to reach the key
            //pause at the key for one second
            PWM_key.write(0);
            wait(1);
            //move bakc to the starting position
            directionPin_key.write(ccw);
            PWM_key.write(1);
            //time needs to be slightly longer than moving forward (no answer why)
            wait(0.165f);
            PWM_key.write(0);
             }
    }
}

