/*
 * read_filter_emg.h
 *
 *  Created on: Oct 14, 2015
 *      Author: User
 */

#ifndef READ_FILTER_EMG_H_
#define READ_FILTER_EMG_H_

class EMG {
    public:
		//create instance of the EMG class
        EMG(AnalogIn &aI_, double &v1_, double &v2_);
        AnalogIn aI(pinName);
        double v1;
		double v2;
        double input_sample;
        double filtered_sample;

        //reads emg value and saves as input_sample
        void sample();

        /*general biquad function to be used in the filtering
        biquad coefficients are in the filter functions */
        double biquad(double u, double &v1, double &v2, const double a1,
        		const double a2, const double b0, const double b1, const double b2);

        //20 hz highpass filter contains 3 biquads. Returns filtered value
        double highpass_filter(double hpInput);

        //Rectify the input (take absolute value). Input is output of highpass
        double rectify(double rcInput);

        //6 hz low pass filter, contains 3 biquads, input output of rectify
        double lowpass_filter(double lpInput);

        //function containing all three filter steps. Input raw signal value, output is filtered envelope value
        double filter(double input);
};

#endif /* READ_FILTER_EMG_H_ */

