/*
 * check_state_change.cpp
 *
 *  Created on: Oct 20, 2015
 *      Author: User
 */

#include "mbed.h"
#include <iostream>

//threashold to turn on the system if it is off
double threashold_turn_on = 10;

//threashold to turn of the system if it is on
double threashold_turn_off = 9;

void check_state_change(std::string &state, std::string newState, int &num_on_inputs, double &threashold)
{
    if (state == newState)
    {
        //add one to the count to track how long the muscle is tense for (update() moves motor if tensed for 0.25s)
    	//if at rest then still tracked but update function will not move the motor only reset num_on_inputs
    	num_on_inputs++;

    }
    else
    {
        //state change so reset the values of on inputs
        num_on_inputs = 0;
        //change state to newState
        state = newState;

        //change the threashold as there has been a change of state
        if (newState == "rest")
        {
        	//we know the system has switched from on to off so set threashold to turn on threashold
        	threashold = threashold_turn_on;
        }

        else
        {
        	//we know the system has switched from rest to left, right, or keypress i.e. off to on
        	threashold = threashold_turn_off;
        }
    }
}





