#include "mbed.h"
//#include "read_filter_emg.h"
//included for fabs() function
#include <math.h>
#include "HIDScope.h"
#include <iostream>
#include "QEI.h"




Serial pc(USBTX, USBRX);

Ticker HIDScope_timer;
Ticker Filteren_timer;
Ticker aansturen;

HIDScope scope(2);

// defining flags
volatile bool Flag_filteren = false;
volatile bool Flag_HIDScope = false;
volatile bool left_movement = false;

// making function flags.
void Go_flag_filteren()
{
    Flag_filteren = true;
}

void Go_flag_HIDScope()
{
    Flag_HIDScope  = true;
}

AnalogIn analog_emg_left(A0);
AnalogIn analog_emg_right(A1);
double input = 0;
double filter_signal_hid = 0;
//double input_right = 0;


//*** making the v for everything and conquer the world***

//for Notchfilter
double notch_v11=0;
double notch_v21=0;
double notch_v12=0;
double notch_v22=0;
double notch_v13=0;
double notch_v23=0;

//for highpass filter
double high_v11=0;
double high_v21=0;
double high_v12=0;
double high_v22=0;
double high_v13=0;
double high_v23=0;

// for lowpasfilter
double low_v11=0;
double low_v21=0;
double low_v12=0;
double low_v22=0;
double low_v13=0;
double low_v23=0;

// for moving average
double n1 = 0;
double n2 = 0;
double n3 = 0;
double n4 = 0;
double n5 = 0;

double filter_left;
double filter_right;

//general biquad filter that can be called in all the filter functions
double biquad(double u, double &v1, double &v2, const double a1,
              const double a2, const double b0, const double b1, const double b2)
{
    double v = u - a1*v1 - a2*v2;
    double y = b0*v + b1*v1 + b2*v2;
    //values of v2 and v1 are updated, as they are passed by reference
    //they update globally
    v2 = v1;
    v1 = v;
    return y;
}

double moving_average(double y, double &n1, double &n2, double &n3, double &n4, double &n5)
{
    double average = (y + n1 + n2 +n3 + n4 + n5)/5;
    n5 = n4;
    n4 = n3;
    n3 = n2;
    n2 = n1;
    n1 = y;

    return average;
}
/*
double threshold(double signal, const double lowtreshold, const double hightreshold)
{
    if (signal > hightreshold)
        left = true;
    else if (signal <lowtreshold)
        left = false;
}
*/
//Specifying filter coefficients highpass

/* notch filter with 3 cascaded biquads*/
//first notch biquad
const double notch1_a1 = -1.55951422433;
const double notch1_a2 = 0.92705680308;
const double notch1_b0 = 1.00000000000;
const double notch1_b1 = -1.61854515325;
const double notch1_b2 = 1.00000000000;

//second notch biquad
const double notch2_a1 = -1.54767435801;
const double notch2_a2 = 0.96124842048;
const double notch2_b0 = 1.00000000000;
const double notch2_b1 = -1.61854515325;
const double notch2_b2 = 1.00000000000;

//third notch biquad
const double notch3_a1 = -1.62600366964;
const double notch3_a2 = 0.96453460373;
const double notch3_b0 = 1.00000000000;
const double notch3_b1 = -1.61854515325;
const double notch3_b2 = 1.00000000000;

/* high pass filter consists of three cascaded biquads
 blow coefficients for those three biquads */
//first high pass biquad
const double highp1_a1 = -0.67538034389;
const double highp1_a2 = 0.12769255668;
const double highp1_b0 = 1.00000000000;
const double highp1_b1 = -2.00000000000;
const double highp1_b2 = 1.00000000000;

//second high pass biquad
const double highp2_a1 = -0.76475499450;
const double highp2_a2 = 0.27692273367;
const double highp2_b0 = 1.00000000000;
const double highp2_b1 = -2.00000000000;
const double highp2_b2 = 1.00000000000;

//third high pass biquad
const double highp3_a1 = -0.99216561242;
const double highp3_a2 = 0.65663360837;
const double highp3_b0 = 1.00000000000;
const double highp3_b1 = -2.00000000000;
const double highp3_b2 = 1.00000000000;

/* lowpass filter consists of three cascaded biquads
below the coefficients for those three biquads */
//first low pass biquad
const double lowp1_a1 = -1.05207469728;
const double lowp1_a2 = 0.28586907478;
const double lowp1_b0 = 1.00000000000;
const double lowp1_b1 = 2.00000000000;
const double lowp1_b2 = 1.00000000000;

//second low pass biquad
const double lowp2_a1 = -1.16338171052;
const double lowp2_a2 = 0.42191097989;
const double lowp2_b0 = 1.00000000000;
const double lowp2_b1 = 2.00000000000;
const double lowp2_b2 = 1.00000000000;

//third low pass biquad
const double lowp3_a1 = -1.42439823874;
const double lowp3_a2 = 0.74093118112;
const double lowp3_b0 = 1.00000000000;
const double lowp3_b1 = 2.00000000000;
const double lowp3_b2 = 1.00000000000;



double Filteren()
{
    input = analog_emg_left.read();
    input = input-0.45; //FIRST SUBTRACT MEAN THEN FILTER
    //input_right = analog_emg_right.read();

    // notch filter
    double y1 = biquad(input, notch_v11, notch_v21, notch1_a1, notch1_a2, notch1_b0, notch1_b1, notch1_b2);
    double y2 = biquad(y1, notch_v12, notch_v22, notch2_a1, notch2_a2, notch2_b0, notch2_b1, notch2_b2);
    double y3 = biquad(y2, notch_v13, notch_v23, notch3_a1, notch3_a2, notch3_b0, notch3_b1, notch3_b2);

    //higpass filter
    double y4 = biquad(y3, high_v11, high_v21, highp1_a1, highp1_a2, highp1_b0, highp1_b1, highp1_b2);
    double y5 = biquad(y4, high_v12, high_v22, highp2_a1, highp2_a2, highp2_b0, highp2_b1, highp2_b2);
    double y6 = biquad(y5, high_v13, high_v23, highp3_a1, highp3_a2, highp3_b0, highp3_b1, highp3_b2);

    //rectivier
    double y7 = fabs(y6);

    //lowpas filter cascade
    double y8 = biquad(y7, low_v11, low_v21, lowp1_a1, lowp1_a2, lowp1_b0, lowp1_b1, lowp1_b2);
    double y9 = biquad(y8, low_v12, low_v22, lowp2_a1, lowp2_a2, lowp2_b0, lowp2_b1, lowp2_b2);
    double y10= biquad(y9, low_v13, low_v23, lowp3_a1, lowp3_a2, lowp3_b0, lowp3_b1, lowp3_b2);

    // moving average
    double filter_signal = moving_average(y10,n1,n2,n3,n4,n5);

double high_threshold = 1200;
double low_threshold = 500;

    if (filter_signal > high_threshold) {
        left_movement = true;
    } else if (filter_signal < low_threshold) {
        left_movement = false;
    }

    return(filter_signal);
}

/*************************************************************BEGIN motor control******************************************************************************************************/
// Define pin for motor control
DigitalOut directionPin(D4);
PwmOut PWM(D5);
DigitalIn buttonccw(PTA4);
DigitalIn buttoncw(PTC6);

QEI wheel (PTC10, PTC11, NC, 624); // Pin for counting (analog in)
// define ticker

// define rotation direction and begin possition
const int cw = 1;
const int ccw = 0;
double setpoint = 0; //setpoint is in pulses

// saying buttons are not pressed
const int Buttoncw_pressed = 0;
const int Buttonccw_pressed = 0;

// Controller gain proportional and intergrator
const double motor1_Kp = 5; // more or les random number.
const double motor1_Ki = 0;
const double M1_timestep = 0.01; // reason ticker works with 100 Hz.
double motor1_error_integraal = 0; // initial value of integral error
// Defining pulses per revolution (calculating pulses to rotations in degree.)
const double pulses_per_revolution = 4200 ;//8400 counts is aangegeven op de motor for x4.  10 - 30 counts oveshoot. for moter 1(tape)! Motor 2 almost the same(nice)
/*
double Rotation = -2; // rotation 
double movement = Rotation * pulses_per_revolution; // times 360 to make Rotations degree.
*/

// defining flags
volatile bool flag_motor = false;

// making function flags.
void Go_flag_motor()
{
    flag_motor = true;
}


// To make a new setpoint 
double making_setpoint(double direction){
    if ( cw == direction){
        setpoint = setpoint + (pulses_per_revolution/40000);
        }
        if ( ccw == direction){
        setpoint = setpoint - (pulses_per_revolution/40000);
        }
    return(setpoint);
    
    }

// Reusable P controller
double PI(double error, const double Kp, const double Ki, double Ts, double &e_int)
{ 

  e_int = e_int + Ts * error;

    double PI_output = (Kp * error) + (Ki * e_int);
    return PI_output;
}
// Next task, measure the error and apply the output to the plant
void motor1_Controller()
{
    double reference = setpoint; // setpoint is in pulses
    double position = wheel.getPulses();
    double error_pulses = (reference - position); // calculate the error in pulses
    double error_rotation = error_pulses / pulses_per_revolution; //calculate how much the rotaions the motor has to turn
    
    double output = abs(PI( error_rotation, motor1_Kp, motor1_Ki, M1_timestep, motor1_error_integraal ));

    if(error_pulses > 0) {
        directionPin.write(cw);
    
    }
    else if(error_pulses < 0) {
        directionPin.write(ccw);  
    }
    else{
        output = 0;
        }
PWM.write(output); // out of the if loop due to abs output


}

/*************************************************************END motor control******************************************************************************************************/

void HIDScope_kijken()
{
    scope.set(0, input);
    scope.set(1, filter_signal_hid);
    scope.send();
}
int main()
{
    aansturen.attach( &Go_flag_motor, 0.01f ); // 100 Hz // timer 0.00001f motor keeps spinning
    HIDScope_timer.attach(&Go_flag_HIDScope, 0.02);
    Filteren_timer.attach(&Go_flag_filteren,0.04);
    while(1) {
        if(Flag_filteren) {
            Flag_filteren = false;
            filter_signal_hid = Filteren();
    
        }

        if(Flag_HIDScope) {
            Flag_HIDScope = false;
            HIDScope_kijken();
        
        }
        
        if(flag_motor) {
            flag_motor = false;
            motor1_Controller();
        
        }

    

// Pussing buttons to get input signal

    if(left_movement){
      setpoint = making_setpoint(cw);
      
        }
if(buttonccw.read() == Buttonccw_pressed) {
          setpoint =  making_setpoint(ccw);
        }
    }
}


    
   
  