/* This code controls the main functions of the servomotor. The servomotor needs an external power of 6 or 12 V and is connected to the PWMOut pin
External power can be either 4*1.5V AA batteries (6V), 8*1.5V AA batteries (12V) or an appropiate DC voltage source. It is important that ground of both the servo motor and mBed platform are the same. 
Servo motor speed can be controlled by an external signal such as a potnetiometer or in context of this project an EMG signal.
*/ 

#include <mbed.h>
#include <Servo.h> 
#include <MODSERIAL.h>
//#include <VarSpeedServo.h>

PwmOut PWM1(D7);
MODSERIAL pc(USBTX,USBRX);
AnalogIn pot(A1);
Ticker potmeterreadout;

/* int PWMfreq(void) {
PWM1.period(0.020); // set PWM period to 10 ms
PWM1=0.5; // set duty cycle to 50%
}
*/

Servo myservo(D7);
volatile float potvalue = 0.0;
float range_servo = 0.001;
float position_servo = 0.05;
float servo_period = 0.01f;

void readpot(){
    potvalue = pot.read();
    //position = motor1.getPosition();
    pc.printf("reference position = %.2f\r", potvalue);
    myservo.calibrate(range_servo, 55.0); 
    myservo = potvalue;
    //motorpid = PID(potvalue - position, M1_KP, M1_KI, M1_KD, M1_TS, m1_err_int, m1_prev_err, m1_f_v1, m1_f_v2, M1_F_A1, M1_F_A2, M1_F_B0, M1_F_B1, M1_F_B2);
    }
 // output PID controller is not yet tested.


int main() {
 
    float range_servo = 0.0008;
    float position_servo = 0.5;
    
    pc.baud(9600);
    potmeterreadout.attach(readpot,0.01f);
    PWM1.period(servo_period);
    
    while(1){            

    }
}


 