#pragma once

#include "mbed.h"
#include "constants.h"


// Pass the two values that you want the target angle outputs in, as 3rd and 4th arguments.
void inverse_kinematics(double Pe_x, double Pe_y, double &dest_main_angle, double &dest_sec_angle)
{
    // Calculation of the position of joint 3 in frame 0
    float n = sqrt(pow((L6-Pe_x),2) + pow(Pe_y,2));                         // Radius between motor 1 and endeffector [meter]
    float omega = acos(-(pow(n,2) - pow(L4,2) - pow(L5,2))/(2*L4*L5));      // Angle between L4 and L5 [rad]
    float q4 = PI - omega;                                                  // Angle of joint 3 between L3 and L4
    float theta = acos( -(pow(L5,2) - pow(n,2) - pow(L4,2))/(2*n*L4) );     // Angle between n and L4
    float lambda_pre_value = Pe_y/(L6-Pe_x);
    float lambda = PI - atan(lambda_pre_value);                               // Entire angle between L0 and n
    dest_main_angle = lambda - theta;
    float J3x_0 = L6 + L4*cos(dest_main_angle);                            // x-coordinate of joint 3 in frame 0
    float J3y_0 = L4*sin(dest_main_angle);                                 // y-coordinate of joint 3 in frame 0
    
    // Calculation of the position of joint 2 in frame 0 
    float S = J3y_0 - Pe_y;                                           // Distance between height endeffector and joint 3
    float kappa = asin(S/L5);                                               // Angle of L5  
    float J2x_0 = (L3+L5)*cos(kappa) + Pe_x;                                // x-coordinate of joint 2 in frame 0
    float J2y_0 = (L3+L5)*sin(kappa) + Pe_y;                                // y-coordinate of joint 2 in frame 0
    
    // Calculation of the position of joint 1 in frame 0
    float J2x_1 = J2x_0 - L0 - L6;                                          // x-coordinate of joint 2 in frame 1
    float J2y_1 = J2y_0;                                                    // y-coordinate of joint 2 in frame 1
    float r = sqrt(pow(J2x_1,2) + pow(J2y_1,2));                            // Radius between origin frame 1 and J2
    float alfa = acos( -(pow(r,2) - pow(L1,2) - pow(L2,2))/(2*L1*L2) );     // Angle opposite of radius r
    float q2 = PI - alfa;                                                   // Angle between L1 and L2
    
    // Delta < 175 graden SAFETY LIMITATION
    if (r > max_r_length)                                        // If delta is larger than 175 degrees then r is this
    {
        r = max_r_length;
    }
    
    // Calculation of motor_angle2
    float beta = acos(- (pow(L2,2) - pow(r,2) - pow(L1,2))/(2*L1*r));       // Angle between r and L1
    float zeta = acos(J2x_1/r);                                             // Angle between r and x-axis of frame 1
    dest_sec_angle = zeta - beta;
    

    // Determining angle delta for safety (not necessary for calculation, for debugging purposes)
    float J1x_0 = L0 + L6 + L1*cos(dest_sec_angle);                       // x-coordinate of joint 1 in frame 0
    float J1y_0 = L1*sin(dest_sec_angle);                                 // y-coordinate of joint 1 in frame 0   
    
    float m = sqrt(pow((J1x_0 - J3x_0),2) + pow((J3y_0 - J1y_0),2));        // Radius between Joint 1 and Joint 3
    float delta = acos(- (pow(m,2) - pow(L2,2) - pow(L3,2))/(2*L2*L3));     // Angle between L2 and L3

    
    // Implementing stops for safety
    // 45 < Motor_angle1 < 160 graden
    if (dest_main_angle < main_arm_min_angle)                             // If motor_angle is smaller than 45 degrees
    {
        dest_main_angle = main_arm_min_angle;
    }
    else if (dest_main_angle > main_arm_max_angle)                         // If motor_angle is larger than 70 degrees
    {
        dest_main_angle = main_arm_max_angle;
    }
    
    // -42 < Motor_angle2 < 85 graden
    if (dest_sec_angle < sec_arm_min_angle)                            // If motor_angle is smaller than -42 degrees
    {
        dest_sec_angle = sec_arm_min_angle;
    }
    else if (dest_sec_angle > sec_arm_max_angle)                         // If motor_angle is larger than 85 degrees
    {
        dest_sec_angle = sec_arm_max_angle;
    }
}