#pragma once

#include "mbed.h"

class Button
{
private:
    DigitalIn pin;

    volatile bool last_state;
    volatile bool pressed;

    volatile bool just_switched_to_pressed;
    volatile bool just_got_pressed;

public:
    Button(PinName pin_name):
        pin(pin_name) {

        last_state = false;
        pressed = false;
        
        just_switched_to_pressed = false;
        just_got_pressed = false;
    }
    
    void poll_pin() {
        // We need to poll the pins periodically.
        // Normally one would use rise and fall interrupts, so this wouldn't be
        // needed. But the buttons we use generate so much chatter that
        // sometimes a rising or a falling edge doesn't get registered.
        // With all the confusion that accompanies it.
        
        bool state = !pin;
        
        // Debounce the button by looking over two periods.
        if (last_state && state && !pressed) {
            pressed = true;
            just_switched_to_pressed = true;
        }
    
        if (!state) {
            pressed = false;
        }
        
        last_state = state;
    }

    void update() {
        if (just_got_pressed) {
            just_got_pressed = false;
        }
        if (just_switched_to_pressed) {
            just_got_pressed = true;
            just_switched_to_pressed = false;
        }
    }

    bool is_pressed() {
        return pressed;
    };
    // Only active just after a state change from not pressed to pressed.
    // Get's reset after `update()` is called.
    bool has_just_been_pressed() {
        return just_got_pressed;
    };
};