#include "mbed.h"
#include "FastPWM.h"
#include "MODSERIAL.h"
#include "HIDScope.h"

// Define Pins
FastPWM pwmpin1(D5);            // SPECIFIC PIN (does not need to be plugged in) Tells you how fast the motor has to go (later: pwmpin.write will tell you the duty cycle, aka how much voltage the motor gets)
FastPWM pwmpin2(D6);            // SPECIFIC PIN (does not need to be plugged in) Tells you how fast the motor has to go (later: pwmpin.write will tell you the duty cycle, aka how much voltage the motor gets)
DigitalOut directionpin1(D4);   // SPECIFIC PIN (does not need to be plugged in) Direction value (0-1) that the mbed will give the motor: in which direction the motor must rotate
DigitalOut directionpin2(D7);   // SPECIFIC PIN (does not need to be plugged in) Direction value (0-1) that the mbed will give the motor: in which direction the motor must rotate
AnalogIn emg0( A0 );            // EMG on Bicep 1a
AnalogIn emg1( A1 );            // EMG on Bicep 1b
//AnalogIn emg2( A2 );            // EMG on Bicep 2a                  CHECK IF THIS WORKS
//AnalogIn emg3( A3 );            // EMG on Bicep 2b                  CHECK IF THIS WORKS
DigitalOut led(LED1);           // LED check for Sample function
InterruptIn button1(PTC6);      // Button interrupt for EMG 1
//InterruptIn button2(PTA4);      // Button interrupt for EMG 2
DigitalOut ledb1(LED_RED);      // LED check for button_pressed1 function
//DigitalOut ledb2(LED_GREEN);    // LED check for button_pressed2 function

// Define variables
Ticker sample_timer;            // Ticker for EMG sample function
HIDScope scope( 2 );            // HIDScope for EMG
Ticker motor;                   // Ticker function for motor function
volatile float u1;              // Motor 1 control signal
//volatile float u2;              // Motor 2 control signal

void sample()                   // Function for getting EMG signals
{
    // Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope'
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
//    scope.set(0, emg2.read() ); //          CHECK IF THIS WORKS
//    scope.set(1, emg3.read() ); //          CHECK IF THIS WORKS
    // Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    // Ensure that enough channels are available (HIDScope scope( 2 ))
    // Finally, send all channels to the PC at once
    scope.send();
    // To indicate that the function is working, the LED is toggled
    led = !led;
}

void button_pressed1()          // Indicates direction of motor 1 becomes negative
    {
        ledb1 = 0;              // Turns on red led as indication of negative direction for motor 1
        directionpin1 = 0;      // Direction for motor 1 becomes negative       CHECK IF THIS WORKS 
    }

//void button_pressed2()          // Indicates direction of motor 2 becomes negative
//    {
//        ledb2 = 0;              // Turns on green led as indication of negative direction for motor 2
//        directionpin2 = 0;      // Direction for motor 2 becomes negative       CHECK IF THIS WORKS 
//    }

void motorfunction()            // Function for motor control
{          
        u1 = emg0.read();                   // EMG1_scale;        // Motor control signal
//        u2 = emg0.read();                   // EMG2_scale;        // Motor control signal
        pwmpin1 = fabs(u1);     // PWM duty cycle can only be positive, floating point absolute value (if value is >0, there still will be a positive value).
//        pwmpin2 = fabs(u2);     // PWM duty cycle can only be positive, floating point absolute value (if value is >0, there still will be a positive value).
}

int main()
{   
    led = 0;
    ledb1 = 0;
//    ledb2 = 1;
    sample_timer.attach(&sample, 0.002);  // 500 Hz
    pwmpin1.period_us(60.0);    //60 microseconds PWM period, 16.7 kHz, defines all PWM pins (only needs to be done once)
    motor.attach(motorfunction,0.5);
    button1.fall(&button_pressed1); // Whenever button 1 falls, execute button_pressed1 function (blinks led red and changes motor direction)
//    button2.fall(&button_pressed2); // Whenever button 2 falls, execute button_pressed1 function (blinks led green and changes motor direction)
    while(1) {}
}