#include "mbed.h"
#include "math.h"
#include "FastPWM.h"
#include "MODSERIAL.h"
#include "QEI.h"

Ticker motor; // Ticker function
Ticker enc; // Ticker function
FastPWM pwmpin1(D5); // SPECIFIC PIN (hoeft niet aangesloten te worden) Tells you how fast the motor has to go (later: pwmpin.write will tell you the duty cycle, aka how much voltage the motor gets)
FastPWM pwmpin2(D6); // SPECIFIC PIN (hoeft niet aangesloten te worden) Tells you how fast the motor has to go (later: pwmpin.write will tell you the duty cycle, aka how much voltage the motor gets)
DigitalOut directionpin1(D4); // SPECIFIC PIN (hoeft niet aangesloten te worden) Direction value (0-1) that the mbed will give the motor: in which direction the motor must rotate
DigitalOut directionpin2(D7); // SPECIFIC PIN (hoeft niet aangesloten te worden) Direction value (0-1) that the mbed will give the motor: in which direction the motor must rotate
AnalogIn potmeter1(A4); // Analoge input van potmeter 1 -> Motor 1
AnalogIn potmeter2(A1); // Analoge input van potmeter 2 -> Motor 2
QEI encoder1(D13, D12, NC, 6533, QEI::X4_ENCODING); // Reads encoder, connect pins of encoder 1 to D12 and D13; NC: not connected pin (for X4); 6533 prm (counts per rotation)
QEI encoder2(D11, D10, NC, 6533, QEI::X4_ENCODING); // Reads encoder, connect pins of encoder 2 to D12 and D13; NC: not connected pin (for X4); 6533 prm (counts per rotation)
Serial pc(USBTX, USBRX);        // Sends encoder counts to PC

volatile float counts_motor1;
volatile float counts_motor2;
volatile float angle_motor1;
volatile float angle_motor2;
volatile float pot1;
volatile float pot2;
volatile float pot1_scale;
volatile float pot2_scale;
volatile float u1;
volatile float u2;
const float PI = 3.14159265359;

void motorfunction()
{       pot1 = potmeter1.read();          // reads out value potmeter 1 between 0-1
        pot1_scale = pot1*2 -1;           // scales value potmeter from 0 - 1 to -1 - 1
        pot2 = potmeter2.read();          // reads out value potmeter 2 between 0-1 
        pot2_scale = pot2*2 -1;           // scales value potmeter from 0 - 1 to -1 - 1       
        u1 = pot1_scale;                  // motor control signal
        u2 = pot2_scale;                  // motor control signal
        directionpin1 = u1 > 0.0f;        // either true or false, determines direction (0 or 1)
        directionpin2 = u2 > 0.0f;        // either true or false, determines direction (0 or 1)
        pwmpin1 = fabs(u1);               // pwm duty cycle can only be positive, floating point absolute value (if value is >0, there still will be a positive value).
        pwmpin2 = fabs(u2);               // pwm duty cycle can only be positive, floating point absolute value (if value is >0, there still will be a positive value).
}
 
void encoder_counter()
{
    counts_motor1 = (float)encoder1.getPulses();       // Gets pulses from encoder 1
    counts_motor2 = (float)encoder2.getPulses();       // Gets pulses from encoder 2
    angle_motor1 = (counts_motor1/6533.0f) * 2.0f*PI;  // Makes angles in rad
    angle_motor2 = (counts_motor2/6533.0f) * 2.0f*PI;  // Makes angles in rad
}

int main()
{
    pwmpin1.period_us(60.0); //60 microseconds PWM period, 16.7 kHz, defines all PWM pins (only needs to be done once)
    motor.attach(motorfunction,0.5);
    enc.attach(encoder_counter,0.5);
    while(1)
    {
    pc.printf("Pulses encoder1 is: %f or %i\n\r angle1 %.2f \n\r Pulses encoder2 is: %f \n\r angle2 %.2f \n\r", counts_motor1, encoder1.getPulses(),angle_motor1, counts_motor2, angle_motor2);
    wait(0.5);
    }
}