#pragma once

class PID {
private:
    double Kp, Ki, Kd;
    double error_integral;
    double error_previous;
    double pid_period; // Time between pid updates.
    bool first_update;
    
    // ---- Low Pass Filter variables ----
    double B[3];
    double A[2];
    double wz[2];
public:
    PID();
    void set_period(double period);
    void set_k_values(double Kp, double Ki, double Kd);
    // Sets the error memory to 0.
    // Leaves the K values intact.
    void clear_state();
    
    double update(double error);

private:
    double biquad_step(double x);
};