#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"
#include "MODSERIAL.h"
#include "BiQuad.h"
#include "FastPWM.h"
#include <iostream>
#include <complex>
#include <vector>

InterruptIn button(SW2);
DigitalOut led(LED1);
DigitalOut flash(LED3);
DigitalOut ledg(LED2);
//char c;


MODSERIAL pc(USBTX, USBRX);
// Example: 4th order Butterworth LP (w_c = 0.1*f_nyquist)
 BiQuad lowpass( 4.16599e-04, 8.33198e-04, 4.16599e-04, -1.47967e+00, 5.55822e-01 );
 BiQuad bq2( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.70096e+00, 7.88500e-01 );
 BiQuadChain bqc;
 
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 2 );



void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

int main()
{
    pc.baud(115200);
    pc.printf("\r\nStarting...\r\n\r\n");
    //pc.attach(ProcessCharacter, MODSERIAL::RxIrq);
    pc.getc();

// button.rise(&flip);  // attach the address of the flip function to the rising edge
 
 
        sample_timer.attach(&sample, 0.002);
     // Add the biquads to the chain


   while(1) {           // wait around, interrupts will interrupt this!

    }

}
