#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"

//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 2 );
DigitalOut  ledred(LED_RED);
DigitalOut  ledgreen(LED_GREEN);
DigitalOut  ledblue(LED_BLUE);
InterruptIn calbutton(PTA4);


const double Fs = 500;  //Sample frequency
double cal_fact = 1;


//------------Filter parameters----------------------

//Lowpassfilter
const double b0LP = 0.0014831498359569692;
const double b1LP = 0.0029662996719139385;
const double b2LP = 0.0014831498359569692;
const double a1LP = -1.918570032544273;
const double a2LP = 0.9245026318881009;
//Highpassfilter
const double b0HP = 0.9921463375688531;
const double b1HP = -1.9842926751377061;
const double b2HP = 0.9921463375688531;
const double a1HP = -1.9841702689557372;
const double a2HP = 0.9844150813196749;
//Notchfilter
const double b0NO = 0.7728616577547288;
const double b1NO = -1.2505164308487402;
const double b2NO = 0.7728616577547288;
const double a1NO = -1.2505164308487402;
const double a2NO = 0.5457233155094577;

//--------------Filter------------
BiQuad LP1( b0LP, b1LP, b2LP, a1LP, a2LP ); //Lowpass filter Biquad
BiQuad HP2( b0HP, b1HP, b2HP, a1HP, a2HP ); //Highpass filter Biquad
BiQuad NO3( b0NO, b1NO, b2NO, a1NO, a2NO ); //Notch filter Biquad 
BiQuadChain BiQuad_filter;
double Signal;
double Signal_filtered;
double Signal_filtered_HP;
double Signal_filtered_fabs;
double Signal_filtered_LP;



/** Sample filter function
 * this function samples the emg, filters it and sends it to HIDScope
 **/
void sample_filter()
{
    Signal = emg0;
    Signal_filtered_HP = HP2.step(Signal);
    Signal_filtered_fabs = fabs(Signal_filtered_HP);
    Signal_filtered_LP = LP1.step(Signal_filtered_fabs);
    Signal_filtered = NO3.step(Signal_filtered_LP) * cal_fact;
 

    //Signal_filtered = fabs(Signal_filtered);        // je wil alleen de absolute waardes
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    //scope.set(1, emg1.read() );
    //scope.set(2, Signal );
    scope.set(1, Signal_filtered);
    /* Repeat the step above if required for more channels of required (channel 0 up to 5 = 6 channels) 
    *  Ensure that enough channels are available (HIDScope scope( 2 ))
    *  Finally, send all channels to the PC at once */
    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    ledred = !ledred;
}

void calibratie()
{
    ledblue = 0;
    cal_fact = 1;
    double cal_max = 0;
    
     for(int i = 0; i < 5*Fs; i++)
    {
        sample_filter();
        if(Signal_filtered > cal_max)
        {
            cal_max = Signal_filtered;
        }
        wait(1/(float)Fs);
   }
   cal_fact = 1.0/cal_max;
   ledblue = 1;
}

int main()
{   
    
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    ledblue = 1;
    sample_timer.attach(&sample_filter, 1/(float)Fs);
    calbutton.rise(&calibratie);
    
    /*empty loop, sample() is executed periodically*/
    while(1) {
        
        if (Signal_filtered > 0.7)
        {   ledgreen = 0;
        }
        else {
            ledgreen = 1;
            }
        
        
        }
    }
    
       