#include "mbed.h"
#include "HIDScope.h"
#include "Biquad.h"

HIDScope scope(5);
Ticker scope_ticker;
const double scope_frequency=100;

///////////INAPUTS
AnalogIn emg1(A0);
AnalogIn emg2(A1);

//////////////////////////////////FILTERS
Biquad myfilter1;//biquad for 1st emg signal
Biquad myfilter2;//biquad for 2nd emg signal

Ticker filter_ticker;
const double filter_frequency=250;
Timer filter_timer;

double filtered1=0;
double filtered2=0;

#include "filtervalues.h"


/////////////////////////GO FLAGS AND ACIVATION FUNCTIONS
volatile bool scope_go=false,filter_go=false;

void scope_activate()
{
    scope_go=true;
}
void filter_activate()
{
    filter_go=true;
}


//////////////////////functions
void scopedata()
{
    scope.set(0,emg1.read());//raw signal emg 1
    scope.set(1,filtered1);//filtered signal emg1
    scope.set(2,emg2.read());//raw signal emg2
    scope.set(3,filtered2);//filtered signal emg2
    scope.set(4,filter_timer.read()); // time it takes to filter both signals
    scope.send();
}

void filtereverything()
{
    filter_timer.reset();
    filter_timer.start();
    //pass1 so f1
    float pass1_emg1 = myfilter1.filter(emg1.read(), v1_f1_emg1 , v2_f1_emg1 , a1_f1 , a2_f1 , b0_f1 , b1_f1 , b2_f1);
    float pass1_emg2 = myfilter2.filter(emg2.read(), v1_f1_emg2 , v2_f1_emg2 , a1_f1 , a2_f1 , b0_f1 , b1_f1 , b2_f1);

    //pass2 so f2
    float pass2_emg1 = myfilter1.filter(pass1_emg1, v1_f2_emg1 , v2_f2_emg1 , a1_f2 , a2_f2 , b0_f2 , b1_f2 , b2_f2);
    float pass2_emg2 = myfilter2.filter(pass1_emg2, v1_f2_emg2 , v2_f2_emg2 , a1_f2 , a2_f2 , b0_f2 , b1_f2 , b2_f2);

    //pass3 so f3
    float pass3_emg1 = myfilter1.filter(pass2_emg1, v1_f3_emg1 , v2_f3_emg1 , a1_f3 , a2_f3 , b0_f3 , b1_f3 , b2_f3);
    float pass3_emg2 = myfilter2.filter(pass2_emg2, v1_f3_emg2 , v2_f3_emg2 , a1_f3 , a2_f3 , b0_f3 , b1_f3 , b2_f3);

    //pass4 so f4
    float pass4_emg1 = myfilter1.filter(pass3_emg1, v1_f4_emg1 , v2_f4_emg1 , a1_f4 , a2_f4 , b0_f4 , b1_f4 , b2_f4);
    float pass4_emg2 = myfilter2.filter(pass3_emg2, v1_f4_emg2 , v2_f4_emg2 , a1_f4 , a2_f4 , b0_f4 , b1_f4 , b2_f4);

    //pass5 so f5
    float pass5_emg1 = myfilter1.filter(pass4_emg1, v1_f5_emg1 , v2_f5_emg1 , a1_f5 , a2_f5 , b0_f5 , b1_f5 , b2_f5);
    float pass5_emg2 = myfilter2.filter(pass4_emg2, v1_f5_emg2 , v2_f5_emg2 , a1_f5 , a2_f5 , b0_f5 , b1_f5 , b2_f5);

    ///// take absolute value
    pass4_emg1=fabs(pass4_emg1);
    pass4_emg2=fabs(pass4_emg2);

    //pass6 so f6
    float pass6_emg1 = myfilter1.filter(pass5_emg1, v1_f6_emg1 , v2_f6_emg1 , a1_f6 , a2_f6 , b0_f6 , b1_f6 , b2_f6);
    float pass6_emg2 = myfilter2.filter(pass5_emg2, v1_f6_emg2 , v2_f6_emg2 , a1_f6 , a2_f6 , b0_f6 , b1_f6 , b2_f6);


    //pass7 so f7
    float pass7_emg1 = myfilter1.filter(pass6_emg1, v1_f7_emg1 , v2_f7_emg1 , a1_f7 , a2_f7 , b0_f7 , b1_f7 , b2_f7);
    float pass7_emg2 = myfilter2.filter(pass6_emg2, v1_f7_emg2 , v2_f7_emg2 , a1_f7 , a2_f7 , b0_f7 , b1_f7 , b2_f7);

    filtered1=pass7_emg1;
    filtered2=pass7_emg2;

    filter_timer.stop();
}

int main()
{
    scope_ticker.attach(&scope_activate,1.0/scope_frequency);
    filter_ticker.attach(&filter_activate,1.0/filter_frequency);

    while(1) {
        if (scope_go==true) {
            scopedata();
            scope_go=false;
        }
        if (filter_go==true) {
            filtereverything();
            filter_go=false;
        }
    }
}
