#ifndef _ANGLEANDPOSITION_H_
#define _ANGLEANDPOSITION_H_

#include "mbed.h"
#include "math.h"

class angleandposition
{
public:
    /**
    *Constructor
    */
    angleandposition(void);

    /**
    *Calculates required angle for rigth arm from desired position.
    *@param x_position : double Desired x position in mm
    *@param y_position : double Desired y position in mm
    *@return Required angle for rigth arm in rad
    */
    double positiontoangle1 (double x_position,double y_position);

    /**
    *Calculates required angle for left arm from desired position.
    *@param x_position : double Desired x position in mm
    *@param y_position : double Desired y position in mm
    *@return Required angle for left arm in rad
    */
    double positiontoangle2 (double x_position,double y_position);
    
    /**
    *Calculates the x position of the pod from the angles of the arms
    *@param theta_r : double Angle of rigth arm in rad
    *@param theta_l : double Angle of left arm in rad
    *@return X position of pod in mm
    */    
    double angletoposition (double theta_r,double theta_l);
    
     /**
    *Calculates the y position of the pod from the angles of the arms
    *@param theta_r : double Angle of rigth arm in rad
    *@param theta_l : double Angle of left arm in rad
    *@return Y position of pod in mm
    */ 
    double angletoposition_y(double theta_r,double theta_l);


private:

};
#endif