#include "mbed.h"
#include "MODSERIAL.h"
#include "math.h"
#include "HIDScope.h"


AnalogIn EMG(A1);
MODSERIAL pc(USBTX, USBRX);

//const int baudrate = 115200;
//const int ms_wait = 100;

// Define the HIDScope and Ticker objects
HIDScope    scope(1);
Ticker scopeTimer;

// Define moving average variables
const int N = 125;
double a;  

 // Define the storage variables and filter coeicients for two filters
 double f1_v1 = 0, f1_v2 = 0, f2_v1 = 0, f2_v2 = 0;
const double f1_a1 =  -1.822694925196308, f1_a2 = 0.837181651256022, f1_b0 = 0.914969144113083, f1_b1 = -1.829938288226165, f1_b2 = 0.914969144113083;
const double f2_a1 = -1.964460580205232, f2_a2 = 0.965081173899135, f2_b0 = 0.000155148423475721, f2_b1 =  0.000310296846951441, f2_b2 = 0.000155148423475721;

 double biquad( double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2 )
 {
 double v = u-a1*v1-a2*v2;
 double y = b0*v + b1*v1 + b2*v2;
 v2 = v1; v1 = v;
 return y;
 }

double sliding_average(double u,const int f_N)
{
    double f_x[f_N];
    double f_sum=0;
    f_x[1]=abs(u);
    for (int i=f_N; i>=1; i--){
        f_x[i]=f_x[i-1];
        }
        
      
    for (int i=f_N; i>=0; i--){
        f_sum=f_x[i]+f_sum;
       }
        a=f_sum/double(f_N);
        f_sum=0;
    return a;
}




void scopeSend(){
 double u1 = EMG.read()  ; //filter 1 input
 double y1 = biquad( u1, f1_v1, f1_v2, f1_a1, f1_a2, f1_b0, f1_b1, f1_b2 );
 double y2 = biquad( fabs(y1), f2_v1, f2_v2, f2_a1, f2_a2, f2_b0, f2_b1, f2_b2 );
 //double z1 = 3*sliding_average(y2, N);
  scope.set(0,y2);
scope.send();
 }
 
int main()
{
    scopeTimer.attach(&scopeSend,0.002);
     while(1){}
        
}