#include "mbed.h"
#include "TCS3472_I2C.h"

Serial pc(USBTX,USBRX);
PwmOut LB(p22);
TCS3472_I2C rgb_sensor(p9, p10);
DigitalOut led[4]= {LED1,LED2,LED3,LED4};
DigitalIn hall(p21);
DigitalOut hallpwr(p22);
int i;

int main()
{
    rgb_sensor.enablePowerAndRGBC();
    rgb_sensor.setIntegrationTime(100);

    pc.baud(9600);
    int rgb_data[4];
    float PWMbrightness=1.0;

    hall.mode(PullUp);
    hallpwr=1;

    while (1) {
        i=hall.read();
        LB=PWMbrightness;
        rgb_sensor.getAllColors(rgb_data);
        pc.printf("unfiltered: %d, red: %d, green: %d, blue: %d \n\r", rgb_data[0], rgb_data[1], rgb_data[2], rgb_data[3]);
        wait(0.1);
        if (rgb_data[0]>10000) {
            pc.printf("No light\n\r");
            led[0]=0;
            led[1]=0;
            led[2]=0;
            led[3]=0;
        } else if((rgb_data[1]>rgb_data[2])&&(rgb_data[1]>rgb_data[3])) {
            pc.printf("Red light\n\r");
            led[0]=1;
            led[1]=0;
            led[2]=0;
            led[3]=0;
            wait(0.2);

        } else if((rgb_data[2]>rgb_data[1])&&(rgb_data[2]>rgb_data[3])) {
            pc.printf("Green light\n\r");
            led[0]=0;
            led[1]=1;
            led[2]=0;
            led[3]=0;
            wait(0.2);

        } else if((rgb_data[3]>rgb_data[1])&&(rgb_data[3]>rgb_data[2])) {
            pc.printf("Blue light\n\r");
            led[0]=0;
            led[1]=0;
            led[2]=1;
            led[3]=0;
            wait(0.2);

        }
        if (i==1) {
            printf("Magnet\n\r");
            led[3]=1;
            hallpwr=0;
            wait (0.5);
            hallpwr=1;
        } else {
            printf("No magnet\n\r");
            led[3]=0;
        }
        wait (0.2);
    }
}

