#include "mbed.h"
#include "stepper.h"

#define stepsPerRound 32000
#define stepsPerDegree stepsPerRound/360.0

void stepperMotor::moveStepper()
{
    if(remain == 0)
    {
        //remain = 0;
        //movedAngle = 0;
        return;
    }
    if(step)
    {
        step = 0; //STEP 1->0
        remain--;
    }
    else
    {
        step = 1; //STEP 0->1
    }
}

void stepperMotor::enable()
{
    en = 0;
}

void stepperMotor::enable(int inputRemain)
{
    setDir(inputRemain >= 0? true: false);
    remain = inputRemain >= 0? inputRemain: -inputRemain;
    enable();
}

stepperMotor::stepperMotor(PinName stepPin, PinName dirPin, PinName enPin, PinName limitSwitchPin, float period): 
    step(stepPin), dir(dirPin), en(enPin), movedAngle(-1), limitSwitch(limitSwitchPin), remain(0)
{
    disable();
    limitSwitch.mode(PullUp);
    stepper.attach(this, &stepperMotor::moveStepper, period);
}

void stepperMotor::init()
{
    enable(-32000);
    while(limitSwitch.read() != 0);
    //while(remain != 0);
    remain = 0;
    movedAngle = 0;
    return;
}

void stepperMotor::disable()
{
    remain = 0;
    en = 1;
}

void stepperMotor::pause()
{
    en = 1;
}

void stepperMotor::moveAngle(double angle)
{
    angle = (angle + movedAngle) > 0 ? angle : -movedAngle;
    int stepsToMove = angle * stepsPerDegree;
    movedAngle += angle;
    enable(stepsToMove);
}

void stepperMotor::setDir(bool direction)
{
    dir = direction;
}

