#include <cstdarg>
#include <cstring>
#include "mbed.h"
#include "esp8266.h"

Serial ser2usb(PA_2, PA_3, 115200);

//DigitalIn ref(PA_12);
//DigitalOut LED(PC_13);
DigitalOut IN1(PB_0);
DigitalOut IN2(PB_1);
DigitalOut IN3(PB_10);
DigitalOut IN4(PB_11);
//PwmOut ENA(PB_1);
//PwmOut ENB(PB_0);
//InterruptIn switch1(PB_6);
bool ready(false), received(false), start(false), done(false);
void run_forwoard();
void run_backwoard();
void stop();
void init();
void after_irq();
int switch_trigger;
int main(void)
{
    IN1 = 0;
    IN2 = 0;
    IN3 = 0;
    IN4 = 0;
//    ENA.period_ms(10);
//    ENB.period_ms(10);
//    ENA.pulsewidth_ms(5);
//    ENB.pulsewidth_ms(5);

    ser2usb.printf("starting\r\n");

    // 选定与 esp8266 相连接的串口，WiFi 名称和密码
    Esp8266 client(PA_9, PA_10, "iot_b827eb8fb527", "7c02b50b"); // 参数分别为 TX pin / RX pin / SSID / Password

    //声明所有的传感器，每行一个，每个由名字、单位两部分组成，最后一行必须为空指针作为结尾
    const char* sensors[][2] = {
        "report", "",
        NULL, NULL //最后一行以空指针作为结束标记
    };

    //声明所有的执行器，每行一个，每个由名字、参数类型两部分组成，最后一行必须为空指针作为结尾
    const char* actuators[][2] = {
        "command", "", 
        "dat", "", 
        NULL, NULL //最后一行以空指针作为结束标记
    };
    ser2usb.printf("connecting...\r\n");

    //连接到服务器
    client.connect_mqtt_broker("192.168.12.1", "car", sensors, actuators);

    client.subscribe_control(actuators[0][0]);
    client.subscribe_control(actuators[1][0]);

    ser2usb.printf("Initialization done.\r\n");
    char actuator_name[32], control_value[32];
    Timer t; // 定时器用于计量发送传感器数据的时间
    t.start();
    //client.publish_value("report", "ready.");
    while(1)
    {
        if (client.get_control_cmd(actuator_name, control_value))
        {
            ser2usb.printf("Received %s %s\r\n", actuator_name, control_value);
            if (strcmp(actuator_name, "command") == 0) 
            {
                ser2usb.printf("Received CMD %s %s\r\n", actuator_name, control_value);
                int the_command = atoi(control_value);
                switch(the_command)
                {
                case 1:
                    ser2usb.printf("server ready\r\n");
                    while (!client.get_control_cmd(actuator_name, control_value))
                    {
                        client.publish_value("report", "wait data.");
                    }
                    break;
                default:
                    break;
                }
            }
        }
        else
        {
            client.publish_value("report", "ready.");
        }
                if(!ready)
        {
            client.publish_value( "report", "ready.");
            //ser2usb.printf("send ready.%d\r\n",flagw);
            ser2usb.printf("ready?\r\n");
            
        }
        if(!start&&ready)
        {
            ser2usb.printf("send start.\r\n");
            client.publish_value("report", "wait data.");
        }
        if(start)
        {
            ser2usb.printf("work start.\r\n");
            client.publish_value("report", "done.");
            ready=0;
            received=0;
            start=0;
            done=0;
        }
    }
}
