#include "mbed.h"
#include "math.h"

Ticker scheduler1;
Ticker scheduler2;
Ticker scheduler3;
Ticker scheduler4;

Serial pc(USBTX, USBRX); // tx, rx

DigitalOut task_1_pin(p8, 0);
DigitalOut task_2_pin(p9, 0);
DigitalOut task_3_pin(p10, 0);

DigitalOut THY_S(p5, 0);
DigitalOut IGBT_G(p6, 0);

DigitalOut led1(LED1, 0);
DigitalOut led2(LED2, 0);
DigitalOut led3(LED3, 0);
DigitalOut led4(LED4, 0);

InterruptIn ButtonPress(p21);

AnalogIn current(p15);
AnalogIn voltage(p16);

// ------------------------- Main Parameters  ------------------------------- //
float resistance = 30.0;
float V_batt = 300.0;
float I_out = 5.0;
float V_out = 0.0;
float freq = 200;     //switching frequency in Hz
Timer TIMER;
float RunTime = 60;  // in seconds

// -------------------- Current Sensor Parameters  --------------------------- //
float HSens_gain = 31;
float I_LIMIT = 8.0;
float i_offset = 0.58;
float i_load = 0;
float i_load_sum = 0;
float i_load_avg = 0;
float i_loadpre = 0;
float i_avg = 0;
float i_sum = 0;
int NUM_SAMPLES = 5;
int count = 0;
int c_i = 0;
int c_i2 = 0;
int a = 0;
int avg_c = 0;
float v_in = 0;
int once = 0;

// ------------------------- Ramp up parameters  ----------------------------- //
float N = 100;        // number of steps
float tramp = 10000;  // ramp time in ms
float tstep = 0;     // step time
float toff = 1;    // cycle off time
float ton_sat = 0;   // ON time saturation value
float toff_sat = 0;  // OFF time saturation value - determines the final duty cycle
float ton = 1;     // on time
float d = 0;         // duty cycle starting point
float d_sat = 0.0;   // determines the final duty cycle
int c = 0;           // step counter
int i = 0;           // cycle counter
int Ncycles = 0;     // Number of cycles



// ----------------------------- Task 1 ------------------------------------- //
// ----------------Current reading and limit testing---------------------------
void task1()
{
    task_1_pin = !task_1_pin;    
    i_load = HSens_gain *3.3*(v_in/3)*( (1.0-current.read())- (1-(v_in*0.5/3)));
   
   
    if(i_load_avg > I_LIMIT) //Overcurrrent
    {
        c_i++;
        if(c_i == 5) 
        {
            
            led3 = 1;            
            c_i = 0;
        }
    }
    
    if((abs(i_load_avg-i_loadpre) > 4)&&(i_loadpre != 0)) // resistance checking
    {
        c_i2++;
        if(c_i2 == 5) 
        {
            
            led2 = 1;            
            c_i2 = 0;
        }
        
        
        
    }
    
    
    
    
    
    avg_c++;
    i_load_sum = i_load_sum + i_load;   //integration
    if(avg_c == (int)(1/freq/0.0001))
    {
        avg_c = 0;
        i_load_avg = (i_load_sum/(1/freq/0.0001));
        i_load_sum = 0;
    }
    
}


// ----------------------------- Task 2 ------------------------------------- //
//------------------------Serial communication----------------------------------
void task2()
{
    task_2_pin = !task_2_pin;
    pc.printf("\r %f", i_load_avg );
    //pc.printf("\r %f", v_in);
    //pc.printf("\r %f", i_loadpre );
}


// ------------------------------ Task 3 ------------------------------------- //
//----------------------------Remote Control----------------------------------
void button()
{
    led1 = !led1;
}
void task3()
{
    task_3_pin = !task_3_pin;
    ButtonPress.rise(&button);   
    v_in = 3.3*(voltage.read());
}


// ------------------------------ Task 4 ------------------------------------- //
//----------------------------XXXXXXXXXXXXXXX----------------------------------
void task4()
{
    //led2 = !led2;
}

// -------------------------- Power Convertor ------------------------------- //
void pw()
{
    IGBT_G= 1;          // set IGBT Ground side pin to high
    wait_us(50);
    THY_S= 1;
    wait_us(10);
    THY_S= 0;    
    wait_us(ton);
    IGBT_G.write(0);
    wait_us(toff);
}

// ------------------------------- MAIN ------------------------------------- //
int main()
{
    pc.baud (115200);
    NVIC_SetPriority(TIMER3_IRQn, 0);
    // set mbed tickers to higher priority than other things

    task_1_pin = 0;
    task_2_pin = 0;
    task_2_pin = 0;
    THY_S = 0;
    IGBT_G = 0;
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;

    scheduler1.attach(&task1, 0.0001); // R check
    scheduler2.attach(&task2, 0.2);    // Reading Hall Sensor
    scheduler3.attach(&task3, 0.5);    // Turn OFF Power
    

    /* Remote Start Prompt */
    
    while(1) {
        if(led1==1) {
            break; // Waiting for start Button (pin21)
        }
    }
    led1 = 0;
    led2 = 0;    
    wait_ms(1);    


//--------Ramp up Start ----------//
    TIMER.start();
    d_sat = resistance*I_out/V_batt;

    if (d_sat > 0.99) {
        d_sat = 0.99; // duty cycle maximum value
    }   
    ton_sat = (float)((d_sat/freq)*1000000);        
    toff_sat = (float)((1/freq)*1000000 - ton_sat); 

    d = 0;
    c = 0;
    tstep = tramp*1000/N;                     //step time calculation in us
    while(c < (int)N) {
        
        d = d + (d_sat/N);           //duty cycle increment
        if (d>d_sat){d=d_sat;}
        ton = (float)((d/freq)*1000000);        //in us     
        toff = (float)((1/freq)*1000000 - ton); //in us               
        Ncycles = (int)(tstep/(ton+toff));   //calculation of the number of cycles
        i = 0;
        while(i < Ncycles) {
            pw();
            i++;
        }
        c++;
    }
    //led3 = 0;
    led4 = 1;   //indicates the ramp up is done
//--------Ramp up End ----------//

    while(1) {

        d = d_sat;            // 0>d<1 duty cycle        
        //d = 0.3;
        ton = (float)((d/freq)*1000000);        
        toff = (float)((1/freq)*1000000 - ton);        
        
        if((led1 == 1)||(led2 == 1)||(led3 == 1)||(TIMER.read()>=RunTime)) //test conditions for break
        {
            break;
        }          
                
        pw();
        if(once==0)
        {
            once = 1;
            i_loadpre = i_load_avg; //acquire reference value
        } 
    }
    
    while(1) // wait for the remote signal before resetting
    {
        if(led1 == 1)
        {
            break;
        }  
    }
    
    TIMER.reset();
    NVIC_SystemReset(); 
      
}