#ifndef UI_H
#define UI_H

#include "mbed.h"
#include "pinconfig.h"
#include "SystemStateConfig.h"

#define UI_DEBUG

class UI
{
public:
    //UI();
    UI(PinName,PinName,PinName,PinName,PinName,PinName);
    int LEDState();
    void LEDWalkOnOff(int,int,int);

    void SwWalk1Tick();
    void SwWalk2Tick();
    void SwWalk3Tick();

    void SwSweepTick();
    void SwWaterTick();
    void SwEmergencyPush();
    void SwEmergencyRelease();

    void BatteryBarLevel();
    void VelocityBarLevel();

    void RunSystem();

    bool getEmergencyStatus() {
        return EmergencyCheck;
    }
    int getSystemState() {
        return SystemState;
    }

private:
    Serial *pc;
    BusOut *VelocityBar,*BatteryBar;
    DigitalOut *LedWalk1, *LedWalk2, *LedWalk3, *LedSweep, *LedWater, *LedStatus;

    DigitalIn SwWalk1, SwWalk2, SwWalk3, SwSweep, SwWater;
    InterruptIn SwEmergency;


    //Timer t;
    //float now;
    //float last;

    volatile int count[3];

    bool EmergencyCheck;

    bool state[2];

    int last_state;
    int now_state;
    
    int SystemState;



};

#endif