#include "UI.h"

UI::UI(PinName a,PinName b,PinName c,PinName d,PinName e ,PinName f) : SwWalk1(a), SwWalk2(b), SwWalk3(c), SwSweep(d), SwWater(e), SwEmergency(f)
{
#ifdef UI_DEBUG
    pc = new Serial(USBTX, USBRX);
    pc->baud(115200);
#endif

    //LED = new BusOut(LED_WALK1, LED_WALK2, LED_WALK3, LED_SWEEP, LED_WATER, LED_STATUS);
    LedWalk1 = new DigitalOut(LED_WALK1);
    LedWalk2 = new DigitalOut(LED_WALK2);
    LedWalk3 = new DigitalOut(LED_WALK3);
    LedSweep = new DigitalOut(LED_SWEEP);
    LedWater = new DigitalOut(LED_WATER);
    LedStatus = new DigitalOut(LED_STATUS);

    LedWalk1->write(0);
    LedWalk2->write(0);
    LedWalk3->write(0);
    LedSweep->write(0);
    LedWater->write(0);
    LedStatus->write(0);

    SwEmergency.rise(this, &UI::SwEmergencyPush);
    SwEmergency.fall(this, &UI::SwEmergencyRelease);

    VelocityBar = new BusOut(LED_BAR1_1, LED_BAR1_2, LED_BAR1_3, LED_BAR1_4, LED_BAR1_5, LED_BAR1_6, LED_BAR1_7, LED_BAR1_8, LED_BAR1_9, LED_BAR1_10);
    BatteryBar = new BusOut(LED_BAR2_1, LED_BAR2_2, LED_BAR2_3, LED_BAR2_4, LED_BAR2_5, LED_BAR2_6, LED_BAR2_7, LED_BAR2_8, LED_BAR2_9, LED_BAR2_10);

    count[0] = count[1] = count[2] = 0;
    last_state = now_state = 0;
    
    state[0] = state[1] = false;

    EmergencyCheck = false;
    
    SystemState = 0;

    //now = 0;
    //t.start(); // for LED Status
    //last = t.read(); // check this again (read or read_ms)
}

int UI::LEDState()
{
#ifdef UI_DEBUG
    pc->printf("LEDState\n");
#endif
    if(1/*Everything Ready*/) {
        LedStatus->write(1);
        return 1;

    } else if(1/*Cannot Communicate*/) {
        LedStatus->write(0);
        return 0;
    }

    else if(1/*Communicated but press Emergency button*/) {

        //check communicate by ping



        LedStatus->write(1);
        wait_ms(300);
        LedStatus->write(0);
        wait_ms(300);
        /*now = t.read();
        if((last-now) > 500) {
            if(LedStatus->read()==0) LedStatus->write(1);
            else LedStatus->write(0);
            last = now;
        }*/
        return 0;
    }
}

void UI::LEDWalkOnOff(int x, int y, int z)
{
    if(x==1) LedWalk1->write(1);
    else LedWalk1->write(0);
    if(y==1) LedWalk2->write(1);
    else LedWalk2->write(0);
    if(z==1) LedWalk3->write(1);
    else LedWalk3->write(0);
}


void UI::SwWalk1Tick()
{
    if(!EmergencyCheck) {
#ifdef UI_DEBUG
        pc->printf("SwitchWalk 1 Ticked\n");
#endif
        now_state = 1;

        if(last_state != now_state) {

            //Walk Style Command

            //Turn LED on
            LEDWalkOnOff(1,0,0);

            last_state = 1;
        }
    }
}

void UI::SwWalk2Tick()
{
    if(!EmergencyCheck) {
#ifdef UI_DEBUG
        pc->printf("SwitchWalk 2 Ticked\n");
#endif

        now_state = 2;

        if(last_state != now_state) {

            //Walk Style Command

            //Turn LED on
            LEDWalkOnOff(0,1,0);
            
            last_state = 2;
        }
    }
}

void UI::SwWalk3Tick()
{
    if(!EmergencyCheck) {
#ifdef UI_DEBUG
        pc->printf("SwitchWalk 3 Ticked\n");
#endif
        now_state = 3;

        if(last_state != now_state) {

            //Walk Style Command

            //Turn LED on
            LEDWalkOnOff(0,0,1);
            last_state = 3;
        }
    }
}

void UI::SwSweepTick()
{
    if(!EmergencyCheck) {
        count[0]++;

#ifdef UI_DEBUG
        pc->printf("Switch Sweep Ticked\n");
#endif

        if(count[0]%2!=0) {
            LedSweep->write(1);
#ifdef UI_DEBUG
            pc->printf("Sweep On\n");
#endif
        } else {
            LedSweep->write(0);
#ifdef UI_DEBUG
            pc->printf("Sweep Off\n");
#endif
        }

        //Send Sweep Command

    }
}

void UI::SwWaterTick()
{
    if(!EmergencyCheck) {
        count[1]++;

#ifdef UI_DEBUG
        pc->printf("Switch Water Ticked\n");
#endif

        if(count[1]%2!=0) {
            LedWater->write(1);
#ifdef UI_DEBUG
            pc->printf("Water On\n");
#endif
        } else {
            LedWater->write(0);
#ifdef UI_DEBUG
            pc->printf("Water Off\n");
#endif
        }

        //Send Water Command

    }
}


void UI::SwEmergencyPush()
{
    EmergencyCheck = true;
    //Send communication command to 'Stop Walking '


    //Turn all LEDs off except 'status LED'
    LEDWalkOnOff(0,0,0);
    LedSweep->write(0);
    LedWater->write(0);

    VelocityBar->write(0b0000000000);

#ifdef UI_DEBUG
    pc->printf("Emergency Button PUSHING\n");
#endif
    count[0] = count[1] = count[2] = 0;
}

void UI::SwEmergencyRelease()
{
    EmergencyCheck = false;
    //Send communication command to 'Stop Walking '


    //Turn all LEDs off except 'status LED'



#ifdef UI_DEBUG
    pc->printf("Emergency Button RELEASE\n");
#endif
}

void UI::BatteryBarLevel()
{
    float value; //Delete this after you get DigitalIn value from battery
    if(value >= 100)
        BatteryBar->write(0b1111111111);
}

void UI::RunSystem()
{
    if(SwWalk1==1) SwWalk1Tick();
    else if(SwWalk2==1) SwWalk2Tick();
    else if(SwWalk3==1) SwWalk3Tick();
    
    if(SwSweep==1){
        SwSweepTick();
        state[0] = true;
    }
    if(state[0]==true && SwSweep==1){
        SwSweepTick();
        state[0] = false;
    }
    
    if(SwWater==1){
        SwWaterTick();
        state[1] = true;
    }
    if(state[1]==true && SwWater==1){
        SwWaterTick();
        state[1] = false;
    }
}